/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.ExplosionBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin
implements ExplosionBridge {
    @Shadow
    @Final
    private ExplosionDamageCalculator damageCalculator;
    @Shadow
    @Final
    private List<BlockPos> toBlow;
    @Shadow
    @Final
    private Map<Player, Vec3> hitPlayers;
    @Shadow
    @Final
    private boolean fire;
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;
    @Shadow
    @Final
    private net.minecraft.world.entity.Entity source;
    @Shadow
    @Final
    private float radius;
    @Shadow
    @Final
    private Explosion.BlockInteraction blockInteraction;
    private boolean impl$shouldBreakBlocks;
    private boolean impl$shouldDamageEntities;
    private int impl$resolution;
    private float impl$randomness;
    private double impl$knockback;

    @Shadow
    public abstract DamageSource shadow$getDamageSource();

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;)V"}, at={@At(value="RETURN")})
    private void impl$onConstructed(Level worldIn, net.minecraft.world.entity.Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.BlockInteraction modeIn, CallbackInfo ci) {
        this.impl$shouldBreakBlocks = this.blockInteraction == Explosion.BlockInteraction.BREAK || this.blockInteraction == Explosion.BlockInteraction.DESTROY;
        this.impl$shouldDamageEntities = true;
        this.impl$resolution = 16;
        this.impl$randomness = 1.0f;
        this.impl$knockback = 1.0;
    }

    @Surrogate
    private void impl$onConstructed(Level worldIn, net.minecraft.world.entity.Entity exploderIn, DamageSource damageSourceIn, ExplosionDamageCalculator explosionContextIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.BlockInteraction modeIn, CallbackInfo ci) {
        this.impl$shouldBreakBlocks = this.blockInteraction == Explosion.BlockInteraction.BREAK || this.blockInteraction == Explosion.BlockInteraction.DESTROY;
        this.impl$shouldDamageEntities = true;
        this.impl$resolution = 16;
        this.impl$randomness = 1.0f;
        this.impl$knockback = 1.0;
    }

    @Overwrite
    public void explode() {
        List list;
        if (this.level.isClientSide) {
            return;
        }
        if (this.impl$shouldBreakBlocks) {
            HashSet set = Sets.newHashSet();
            int i = 16;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.x;
                        double d6 = this.y;
                        double d8 = this.z;
                        float f1 = 0.3f;
                        for (float f = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            FluidState fluidstate;
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            BlockState blockstate = this.level.getBlockState(blockpos);
                            Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate = this.level.getFluidState(blockpos));
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
            this.toBlow.addAll(set);
        }
        float f3 = this.radius * 2.0f;
        int k1 = Mth.floor((double)(this.x - (double)f3 - 1.0));
        int l1 = Mth.floor((double)(this.x + (double)f3 + 1.0));
        int i2 = Mth.floor((double)(this.y - (double)f3 - 1.0));
        int i1 = Mth.floor((double)(this.y + (double)f3 + 1.0));
        int j2 = Mth.floor((double)(this.z - (double)f3 - 1.0));
        int j1 = Mth.floor((double)(this.z + (double)f3 + 1.0));
        List list2 = list = this.impl$shouldDamageEntities ? this.level.getEntities(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1)) : Collections.emptyList();
        if (ShouldFire.EXPLOSION_EVENT_DETONATE) {
            ArrayList<ServerLocation> blockPositions = new ArrayList<ServerLocation>(this.toBlow.size());
            ArrayList<Entity> entities = new ArrayList<Entity>(list.size());
            for (BlockPos pos : this.toBlow) {
                blockPositions.add(ServerLocation.of((ServerWorld)this.level, pos.getX(), pos.getY(), pos.getZ()));
            }
            for (net.minecraft.world.entity.Entity entity : list) {
                if (entity.ignoreExplosion()) continue;
                entities.add((Entity)entity);
            }
            Cause cause = PhaseTracker.getCauseStackManager().currentCause();
            ExplosionEvent.Detonate detonate = SpongeEventFactory.createExplosionEventDetonate(cause, blockPositions, entities, (org.spongepowered.api.world.explosion.Explosion)((Object)this), (ServerWorld)this.level);
            SpongeCommon.post(detonate);
            this.toBlow.clear();
            if (detonate.isCancelled()) {
                return;
            }
            if (this.impl$shouldBreakBlocks) {
                for (ServerLocation worldLocation : detonate.affectedLocations()) {
                    this.toBlow.add(VecHelper.toBlockPos(worldLocation));
                }
            }
            list.clear();
            if (this.impl$shouldDamageEntities) {
                for (Entity entity : detonate.entities()) {
                    try {
                        list.add((net.minecraft.world.entity.Entity)entity);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        Vec3 vec3d = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)list.get(k2);
            if (entity.ignoreExplosion() || !((d12 = Math.sqrt(entity.distanceToSqr(vec3d)) / (double)f3) <= 1.0) || (d13 = Math.sqrt((d5 = entity.getX() - this.x) * d5 + (d7 = entity.getEyeY() - this.y) * d7 + (d9 = entity.getZ() - this.z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Explosion.getSeenPercent((Vec3)vec3d, (net.minecraft.world.entity.Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.hurt(this.shadow$getDamageSource(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.getExplosionKnockbackAfterDampener((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(d5 * d11 * this.impl$knockback, d7 * d11 * this.impl$knockback, d9 * d11 * this.impl$knockback));
            if (!(entity instanceof Player) || (playerentity = (Player)entity).isSpectator() || playerentity.isCreative() && playerentity.getAbilities().flying) continue;
            this.hitPlayers.put(playerentity, new Vec3(d5 * d10 * this.impl$knockback, d7 * d10 * this.impl$knockback, d9 * d10 * this.impl$knockback));
        }
    }

    @Override
    public boolean bridge$getShouldDamageBlocks() {
        return this.impl$shouldBreakBlocks;
    }

    @Override
    public boolean bridge$getShouldDamageEntities() {
        return this.impl$shouldDamageEntities;
    }

    @Override
    public void bridge$setShouldBreakBlocks(boolean shouldBreakBlocks) {
        this.impl$shouldBreakBlocks = shouldBreakBlocks;
    }

    @Override
    public void bridge$setShouldDamageEntities(boolean shouldDamageEntities) {
        this.impl$shouldDamageEntities = shouldDamageEntities;
    }

    @Override
    public void bridge$setResolution(int resolution) {
        this.impl$resolution = resolution;
    }

    @Override
    public int bridge$getResolution() {
        return this.impl$resolution;
    }

    @Override
    public void bridge$setRandomness(float randomness) {
        this.impl$randomness = randomness;
    }

    @Override
    public float bridge$getRandomness() {
        return this.impl$randomness;
    }

    @Override
    public void bridge$setKnockback(double knockback) {
        this.impl$knockback = knockback;
    }

    @Override
    public double bridge$getKnockback() {
        return this.impl$knockback;
    }

    public String toString() {
        return new StringJoiner(", ", ExplosionMixin.class.getSimpleName() + "[", "]").add("causesFire=" + this.fire).add("mode=" + this.blockInteraction).add("world=" + this.level).add("x=" + this.x).add("y=" + this.y).add("z=" + this.z).add("exploder=" + this.source).add("size=" + this.radius).add("affectedBlockPositions=" + this.toBlow).add("playerKnockbackMap=" + this.hitPlayers).add("shouldBreakBlocks=" + this.impl$shouldBreakBlocks).add("shouldDamageEntities=" + this.impl$shouldDamageEntities).add("resolution=" + this.impl$resolution).add("randomness=" + this.impl$randomness).add("knockback=" + this.impl$knockback).toString();
    }
}

