/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.chunk;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.TickList;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoTickList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin_Tracker
implements TrackedLevelChunkBridge {
    @Shadow
    @Final
    public static LevelChunkSection EMPTY_SECTION;
    @Shadow
    @Final
    private LevelChunkSection[] sections;
    @Shadow
    @Final
    private Level level;
    private @MonotonicNonNull PhaseContext<@NonNull ?> tracker$postProcessContext = null;

    @Shadow
    public abstract @Nullable BlockEntity shadow$getBlockEntity(BlockPos var1, LevelChunk.EntityCreationType var2);

    @Shadow
    public abstract BlockState getBlockState(BlockPos var1);

    @Inject(method={"setBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void tracker$sanityCheckServerWorldSetBlockState(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> cir) {
        if (!((LevelBridge)this.level).bridge$isFake()) {
            new PrettyPrinter(80).add("Illegal Direct Chunk Access").hr().add(new IllegalAccessException("No one should be accessing Chunk.setBlock in a ServerWorld's environment")).log(PhaseTracker.LOGGER, org.apache.logging.log4j.Level.WARN);
            cir.setReturnValue(null);
        }
    }

    @Override
    public @NonNull ChunkPipeline bridge$createChunkPipeline(BlockPos pos, BlockState newState, BlockState currentState, SpongeBlockChangeFlag flag, int limit) {
        boolean isFake = ((LevelBridge)this.level).bridge$isFake();
        if (isFake) {
            throw new IllegalStateException("Cannot call ChunkBridge.bridge$buildChunkPipeline in non-Server managed worlds");
        }
        int xPos = pos.getX() & 0xF;
        int yPos = pos.getY();
        int zPos = pos.getZ() & 0xF;
        int sectionIndex = ((LevelChunk)this).getSectionIndex(yPos);
        LevelChunkSection chunksection = this.sections[sectionIndex];
        if (chunksection == EMPTY_SECTION) {
            if (newState.isAir()) {
                return ChunkPipeline.nullReturn((LevelChunk)this, (ServerLevel)this.level);
            }
            this.sections[sectionIndex] = chunksection = new LevelChunkSection(SectionPos.blockToSectionCoord((int)yPos));
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        @Nullable BlockEntity existing = this.shadow$getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        WeakReference<ServerLevel> ref = new WeakReference<ServerLevel>((ServerLevel)this.level);
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, pos, flag, limit, existing, () -> Objects.requireNonNull((ServerLevel)ref.get(), "ServerWorld dereferenced"), Optional::empty, Optional::empty);
        ChangeBlock transaction = context.createTransaction(snapshot, newState, flag);
        snapshot.blockChange = context.associateBlockChangeWithSnapshot(newState, currentState);
        if (((BlockStateBridge)((Object)snapshot.state())).bridge$hasTileEntity() && (snapshot.blockChange == BlockChange.BREAK || snapshot.blockChange == BlockChange.MODIFY)) {
            transaction.queuedRemoval = existing;
        }
        ChunkPipeline.Builder builder = ChunkPipeline.builder().kickOff(transaction).chunk((LevelChunk)this).chunkSection(chunksection).world((ServerLevel)this.level);
        transaction.populateChunkEffects(builder);
        return builder.build();
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="HEAD")})
    private void tracker$startChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext != null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.SERVER, "Expected to not have a chunk post process", "Chunk Post Process has not completed!", GenerationPhase.State.CHUNK_LOADING, this.tracker$postProcessContext, (Throwable)new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
            this.tracker$postProcessContext.close();
        }
        this.tracker$postProcessContext = ((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER).chunk((LevelChunk)this).world((ServerLevel)this.level)).buildAndSwitch();
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="RETURN")})
    private void tracker$endChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext == null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Expected to complete Chunk Post Process", "Chunk Post Process has a null PhaseContext", new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
        }
        this.tracker$postProcessContext.close();
        this.tracker$postProcessContext = null;
    }

    @Inject(method={"setBlockEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;clearRemoved()V")})
    private void tracker$SetActiveChunkOnTileEntityAdd(BlockEntity tileEntityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(this);
        ((CreatorTrackedBridge)tileEntityIn).tracked$setTrackedUUID(PlayerTracker.Type.CREATOR, ((LevelChunkBridge)((Object)this)).bridge$getBlockCreatorUUID(tileEntityIn.getBlockPos()).orElse(null));
        ((CreatorTrackedBridge)tileEntityIn).tracked$setTrackedUUID(PlayerTracker.Type.NOTIFIER, null);
    }

    @Redirect(method={"unpackTicks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ProtoTickList;copyOut(Lnet/minecraft/world/level/TickList;Ljava/util/function/Function;)V"))
    private void tracker$wrapRescheduledTicks(ProtoTickList chunkPrimerTickList, TickList<?> tickList, Function<BlockPos, ?> func) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        try (ChunkLoadContext context = GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER);){
            context.chunk((LevelChunk)this);
            context.buildAndSwitch();
            chunkPrimerTickList.copyOut(tickList, func);
        }
    }
}

