/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import java.net.InetSocketAddress;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.StatusClient;
import org.spongepowered.api.network.status.StatusResponse;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.network.status.SpongeLegacyStatusClient;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeStatusResponse {
    private SpongeStatusResponse() {
    }

    public static @Nullable ServerStatus post(MinecraftServer server, StatusClient client) {
        return SpongeStatusResponse.call(SpongeStatusResponse.create(server), client);
    }

    public static @Nullable ServerStatus postLegacy(MinecraftServer server, InetSocketAddress address, MinecraftVersion version, InetSocketAddress virtualHost) {
        ServerStatus response = SpongeStatusResponse.create(server);
        response.setVersion(new ServerStatus.Version(response.getVersion().getName(), 127));
        response = SpongeStatusResponse.call(response, new SpongeLegacyStatusClient(address, version, virtualHost));
        if (response != null && response.getPlayers() == null) {
            response.setPlayers(new ServerStatus.Players(-1, 0));
        }
        return response;
    }

    private static @Nullable ServerStatus call(ServerStatus response, StatusClient client) {
        if (!SpongeCommon.post(SpongeEventFactory.createClientPingServerEvent(Cause.of(EventContext.empty(), Sponge.server()), client, (ClientPingServerEvent.Response)response))) {
            return response;
        }
        return null;
    }

    public static ServerStatus create(MinecraftServer server) {
        return SpongeStatusResponse.clone(server.getStatus());
    }

    private static ServerStatus clone(ServerStatus original) {
        ServerStatus clone = new ServerStatus();
        clone.setDescription(original.getDescription());
        if (original.getFavicon() != null) {
            ((ClientPingServerEvent.Response)clone).setFavicon(((StatusResponse)original).favicon().get());
        }
        clone.setPlayers(SpongeStatusResponse.clone(original.getPlayers()));
        clone.setVersion(SpongeStatusResponse.clone(original.getVersion()));
        return clone;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ServerStatus.Players clone(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ServerStatus.Players original) {
        if (original != null) {
            ServerStatus.Players clone = new ServerStatus.Players(original.getMaxPlayers(), original.getNumPlayers());
            clone.setSample(original.getSample());
            return clone;
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ServerStatus.Version clone(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ServerStatus.Version original) {
        return original != null ? new ServerStatus.Version(original.getName(), original.getProtocol()) : null;
    }

    public static String getMotd(ServerStatus response) {
        return SpongeStatusResponse.getFirstLine(LegacyComponentSerializer.legacySection().serialize(SpongeAdventure.asAdventure(response.getDescription())));
    }

    public static String getUnformattedMotd(ServerStatus response) {
        return SpongeStatusResponse.getFirstLine(PlainTextComponentSerializer.plainText().serialize(SpongeAdventure.asAdventure(response.getDescription())));
    }

    private static String getFirstLine(String s) {
        return NetworkUtil.substringBefore(s, '\n');
    }
}

