/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StaticTagHelper;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryRoots;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.common.accessor.core.RegistryAccessAccessor;
import org.spongepowered.common.accessor.resources.ResourceKeyAccessor;
import org.spongepowered.common.bridge.core.WritableRegistryBridge;
import org.spongepowered.common.registry.CallbackRegistry;
import org.spongepowered.common.registry.InitialRegistryData;
import org.spongepowered.common.registry.RegistryLoader;
import org.spongepowered.common.registry.TagRegistry;

public final class RegistryHolderLogic
implements RegistryHolder {
    private final Map<org.spongepowered.api.ResourceKey, net.minecraft.core.Registry<net.minecraft.core.Registry<?>>> roots = new Object2ObjectOpenHashMap();

    public RegistryHolderLogic() {
        this.roots.put((org.spongepowered.api.ResourceKey)new ResourceLocation("minecraft", "root"), (net.minecraft.core.Registry<net.minecraft.core.Registry<?>>)new MappedRegistry(ResourceKey.createRegistryKey((ResourceLocation)((ResourceLocation)RegistryRoots.MINECRAFT)), Lifecycle.experimental()));
        ResourceLocation sponge = new ResourceLocation("sponge", "root");
        this.roots.put((org.spongepowered.api.ResourceKey)sponge, (net.minecraft.core.Registry<net.minecraft.core.Registry<?>>)new MappedRegistry(ResourceKeyAccessor.invoker$create(sponge, sponge), Lifecycle.stable()));
    }

    public RegistryHolderLogic(RegistryAccess dynamicAccess) {
        this();
        WritableRegistry root = (WritableRegistry)this.roots.get(new ResourceLocation("minecraft", "root"));
        for (ResourceKey<? extends net.minecraft.core.Registry<?>> resourceKey : RegistryAccessAccessor.accessor$REGISTRIES().keySet()) {
            net.minecraft.core.Registry registry = dynamicAccess.registryOrThrow(resourceKey);
            root.register(resourceKey, (Object)registry, Lifecycle.stable());
        }
    }

    public void setRootMinecraftRegistry(net.minecraft.core.Registry<net.minecraft.core.Registry<?>> rootRegistry) {
        this.roots.put(RegistryRoots.MINECRAFT, rootRegistry);
    }

    @Override
    public <T> Registry<T> registry(RegistryType<T> type) {
        net.minecraft.core.Registry<net.minecraft.core.Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        net.minecraft.core.Registry registry = (net.minecraft.core.Registry)root.get((ResourceLocation)type.location());
        if (registry == null) {
            throw new ValueNotFoundException(String.format("No '%s' registry has been defined in root '%s'", type.location(), type.root()));
        }
        return (Registry)registry;
    }

    @Override
    public <T> Optional<Registry<T>> findRegistry(RegistryType<T> type) {
        net.minecraft.core.Registry<net.minecraft.core.Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            return Optional.empty();
        }
        return root.getOptional((ResourceLocation)type.location());
    }

    @Override
    public Stream<Registry<?>> streamRegistries(org.spongepowered.api.ResourceKey root) {
        net.minecraft.core.Registry<net.minecraft.core.Registry<?>> rootRegistry = this.roots.get(Objects.requireNonNull(root, "root"));
        if (rootRegistry == null) {
            return Stream.empty();
        }
        return rootRegistry.stream();
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Map<org.spongepowered.api.ResourceKey, T> defaultValues) {
        return this.createRegistry(type, defaultValues != null ? () -> defaultValues : null, false);
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<org.spongepowered.api.ResourceKey, T>> defaultValues) {
        return this.createRegistry(type, defaultValues, false);
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<org.spongepowered.api.ResourceKey, T>> defaultValues, boolean isDynamic) {
        return this.createRegistry(type, InitialRegistryData.noIds(defaultValues), isDynamic, null);
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader) {
        return this.createRegistry(type, loader, false);
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader, boolean isDynamic) {
        return this.createRegistry(type, loader, isDynamic, null);
    }

    public <T> Registry<T> createRegistry(RegistryType<T> type, @Nullable InitialRegistryData<T> defaultValues, boolean isDynamic, @Nullable BiConsumer<ResourceKey<T>, T> callback) {
        net.minecraft.core.Registry<net.minecraft.core.Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        Object registry = (net.minecraft.core.Registry)root.get((ResourceLocation)type.location());
        if (registry != null) {
            throw new DuplicateRegistrationException(String.format("Registry '%s' in root '%s' has already been defined", type.location(), type.root()));
        }
        ResourceKey key = net.minecraft.core.Registry.ROOT_REGISTRY_NAME.equals((Object)type.root()) ? ResourceKey.createRegistryKey((ResourceLocation)((ResourceLocation)type.location())) : ResourceKeyAccessor.invoker$create((ResourceLocation)RegistryRoots.SPONGE, (ResourceLocation)type.location());
        registry = callback == null ? new MappedRegistry(key, Lifecycle.stable()) : new CallbackRegistry<T>(key, Lifecycle.stable(), callback);
        ((WritableRegistryBridge)registry).bridge$setDynamic(isDynamic);
        if (defaultValues != null) {
            MappedRegistry mr = (MappedRegistry)registry;
            defaultValues.forEach((vk, vi, vv) -> mr.registerOrOverride(vi, ResourceKey.create((ResourceKey)key, (ResourceLocation)((ResourceLocation)vk)), vv, Lifecycle.stable()));
        }
        ((WritableRegistry)root).register(key, registry, Lifecycle.stable());
        if (registry instanceof CallbackRegistry) {
            ((CallbackRegistry)((Object)registry)).setCallbackEnabled(true);
        }
        return (Registry)registry;
    }

    public <T> Registry<T> wrapTagHelperAsRegistry(RegistryType<Tag<T>> type, StaticTagHelper<T> staticTagHelper) {
        net.minecraft.core.Registry<net.minecraft.core.Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        TagRegistry<T> registry = (TagRegistry<T>)((Object)root.get((ResourceLocation)type.location()));
        if (registry != null) {
            throw new DuplicateRegistrationException(String.format("Registry '%s' in root '%s' has already been defined", type.location(), type.root()));
        }
        ResourceKey key = net.minecraft.core.Registry.ROOT_REGISTRY_NAME.equals((Object)type.root()) ? ResourceKey.createRegistryKey((ResourceLocation)((ResourceLocation)type.location())) : ResourceKeyAccessor.invoker$create((ResourceLocation)RegistryRoots.SPONGE, (ResourceLocation)type.location());
        registry = new TagRegistry<T>(key, staticTagHelper, Lifecycle.stable());
        ((WritableRegistry)root).register(key, registry, Lifecycle.stable());
        return (Registry)((Object)registry);
    }
}

