/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.api.ResourceKey;

public final class SpongeResourceKeyBuilder
implements ResourceKey.Builder {
    private String namespace;
    private String value;

    @Override
    public ResourceKey.Builder namespace(String namespace) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        this.namespace = namespace;
        return this;
    }

    @Override
    public ResourceKey.Builder value(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null");
        this.value = value;
        return this;
    }

    @Override
    public ResourceKey build() throws IllegalStateException {
        Preconditions.checkState((this.namespace != null ? 1 : 0) != 0, (Object)"Namespace cannot be empty");
        Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"Value cannot be empty");
        try {
            ResourceLocation resourceLocation = new ResourceLocation(this.namespace, this.value);
            return (ResourceKey)resourceLocation;
        }
        catch (ResourceLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ResourceKey.Builder reset() {
        this.namespace = null;
        this.value = null;
        return this;
    }
}

