/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;

public class SpongeContextCalculator
implements ContextCalculator {
    private final LoadingCache<RemoteConnection, Set<Context>> remoteIpCache = this.buildAddressCache("remoteip", rs -> SpongeContextCalculator.address(rs, RemoteConnection::address));
    private final LoadingCache<RemoteConnection, Set<Context>> localIpCache = this.buildAddressCache("localip", rs -> SpongeContextCalculator.address(rs, RemoteConnection::virtualHost));

    private static InetAddress address(RemoteConnection input, Function<RemoteConnection, InetSocketAddress> func) {
        InetSocketAddress socket = func.apply(input);
        if (!socket.isUnresolved()) {
            return socket.getAddress();
        }
        try {
            return InetAddress.getByName(socket.getHostName());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private LoadingCache<RemoteConnection, Set<Context>> buildAddressCache(String contextKey, Function<RemoteConnection, InetAddress> function) {
        return Caffeine.newBuilder().weakKeys().build(key -> {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            InetAddress addr = (InetAddress)function.apply((RemoteConnection)key);
            if (addr == null) {
                return builder.build();
            }
            builder.add((Object)new Context(contextKey, addr.getHostAddress()));
            for (Map.Entry<String, Predicate<InetAddress>> entry : SpongeConfigs.getCommon().get().getIpSets().entrySet()) {
                if (!entry.getValue().test(addr)) continue;
                builder.add((Object)new Context(contextKey, entry.getKey()));
            }
            return builder.build();
        });
    }

    @Override
    public void accumulateContexts(Cause causes, Consumer<Context> accumulator) {
        ServerWorld world;
        ServerLocation location = causes.context().get(EventContextKeys.LOCATION).orElse(null);
        if (location != null && (world = (ServerWorld)location.worldIfAvailable().orElse(null)) != null) {
            accumulator.accept(world.context());
            accumulator.accept(world.worldType().context());
        }
        causes.first(RemoteConnection.class).ifPresent(connection -> {
            ((Set)this.remoteIpCache.get(connection)).forEach(accumulator);
            ((Set)this.localIpCache.get(connection)).forEach(accumulator);
            accumulator.accept(new Context("localport", String.valueOf(connection.virtualHost().getPort())));
            accumulator.accept(new Context("localhost", connection.virtualHost().getHostName()));
        });
    }
}

