/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.Objects;
import java.util.function.Supplier;

public final class MemoizedSupplier<T>
implements Supplier<T> {
    final Supplier<T> delegate;
    volatile transient boolean initialized;
    transient T value;

    public static <V> Supplier<V> memoize(Supplier<V> supplier) {
        return new MemoizedSupplier<V>(supplier);
    }

    private MemoizedSupplier(Supplier<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            MemoizedSupplier memoizedSupplier = this;
            synchronized (memoizedSupplier) {
                if (!this.initialized) {
                    T t = this.delegate.get();
                    this.value = t;
                    this.initialized = true;
                    return t;
                }
            }
        }
        return this.value;
    }
}

