/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.PortionTypes;

public final class PortionTypeUtil {
    public static @Nullable PortionType getFromBedBlock(BlockState holder, EnumProperty<BedPart> property) {
        BedPart part = (BedPart)holder.getValue(property);
        switch (part) {
            case HEAD: {
                return PortionTypes.TOP.get();
            }
            case FOOT: {
                return PortionTypes.BOTTOM.get();
            }
        }
        return null;
    }

    public static @Nullable BlockState setForBedBlock(BlockState holder, PortionType value, EnumProperty<BedPart> property) {
        if (value == PortionTypes.TOP.get()) {
            return (BlockState)holder.setValue(property, (Comparable)BedPart.HEAD);
        }
        if (value == PortionTypes.BOTTOM.get()) {
            return (BlockState)holder.setValue(property, (Comparable)BedPart.FOOT);
        }
        return null;
    }

    public static PortionType getFromDoubleBlock(BlockState holder, EnumProperty<DoubleBlockHalf> property) {
        DoubleBlockHalf half = (DoubleBlockHalf)holder.getValue(property);
        return half == DoubleBlockHalf.LOWER ? PortionTypes.BOTTOM.get() : PortionTypes.TOP.get();
    }

    public static BlockState setForDoubleBlock(BlockState holder, PortionType value, EnumProperty<DoubleBlockHalf> property) {
        DoubleBlockHalf half = value == PortionTypes.TOP.get() ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER;
        return (BlockState)holder.setValue(property, (Comparable)half);
    }

    public static PortionType getFromHalfBlock(BlockState holder, EnumProperty<Half> property) {
        Half half = (Half)holder.getValue(property);
        return half == Half.BOTTOM ? PortionTypes.BOTTOM.get() : PortionTypes.TOP.get();
    }

    public static BlockState setForHalfBlock(BlockState holder, PortionType value, EnumProperty<Half> property) {
        Half half = value == PortionTypes.TOP.get() ? Half.TOP : Half.BOTTOM;
        return (BlockState)holder.setValue(property, (Comparable)half);
    }

    private PortionTypeUtil() {
    }
}

