/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome.provider;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.api.world.biome.provider.multinoise.MultiNoiseConfig;
import org.spongepowered.common.accessor.world.level.biome.MultiNoiseBiomeSourceAccessor;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.SeedUtil;
import org.spongepowered.common.world.biome.provider.AbstractBiomeProviderConfig;

public final class SpongeMultiNoiseBiomeConfig
extends AbstractBiomeProviderConfig
implements MultiNoiseBiomeConfig {
    private final long seed;
    private final List<AttributedBiome> biomes;
    private final MultiNoiseConfig temperatureConfig;
    private final MultiNoiseConfig humidityConfig;
    private final MultiNoiseConfig altitudeConfig;
    private final MultiNoiseConfig weirdnessConfig;

    protected SpongeMultiNoiseBiomeConfig(BuilderImpl builder) {
        super(builder.biomes.stream().map(b -> b.biome()).collect(Collectors.toList()));
        this.seed = builder.seed;
        this.biomes = builder.biomes;
        this.temperatureConfig = builder.temperatureConfig;
        this.humidityConfig = builder.humidityConfig;
        this.altitudeConfig = builder.altitudeConfig;
        this.weirdnessConfig = builder.weirdnessConfig;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public List<AttributedBiome> attributedBiomes() {
        return this.biomes;
    }

    @Override
    public MultiNoiseConfig temperatureConfig() {
        return this.temperatureConfig;
    }

    @Override
    public MultiNoiseConfig humidityConfig() {
        return this.humidityConfig;
    }

    @Override
    public MultiNoiseConfig altitudeConfig() {
        return this.altitudeConfig;
    }

    @Override
    public MultiNoiseConfig weirdnessConfig() {
        return this.weirdnessConfig;
    }

    public static final class BuilderImpl
    implements MultiNoiseBiomeConfig.Builder {
        public long seed;
        public final List<AttributedBiome> biomes = new ArrayList<AttributedBiome>();
        public MultiNoiseConfig temperatureConfig;
        public MultiNoiseConfig humidityConfig;
        public MultiNoiseConfig altitudeConfig;
        public MultiNoiseConfig weirdnessConfig;

        @Override
        public MultiNoiseBiomeConfig.Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder seed(String seed) {
            this.seed = SeedUtil.compute(seed);
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder addBiome(AttributedBiome biome) {
            this.biomes.add(Objects.requireNonNull(biome, "biome"));
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder addBiomes(List<AttributedBiome> biomes) {
            this.biomes.addAll((Collection<AttributedBiome>)Objects.requireNonNull(biomes, "biomes"));
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder removeBiome(RegistryReference<Biome> biome) {
            Objects.requireNonNull(biome, "biome");
            Iterator<AttributedBiome> iter = this.biomes.iterator();
            while (iter.hasNext()) {
                if (!iter.next().biome().equals(biome)) continue;
                iter.remove();
                break;
            }
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder temperatureConfig(MultiNoiseConfig temperatureConfig) {
            this.temperatureConfig = Objects.requireNonNull(temperatureConfig, "temperatureConfig");
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder humidityConfig(MultiNoiseConfig humidityConfig) {
            this.humidityConfig = Objects.requireNonNull(humidityConfig, "humidityConfig");
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder altitudeConfig(MultiNoiseConfig altitudeConfig) {
            this.altitudeConfig = Objects.requireNonNull(altitudeConfig, "altitudeConfig");
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder weirdnessConfig(MultiNoiseConfig weirdnessConfig) {
            this.weirdnessConfig = Objects.requireNonNull(weirdnessConfig, "weirdnessConfig");
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder from(MultiNoiseBiomeConfig value) {
            this.biomes.clear();
            this.seed = Objects.requireNonNull(value, "value").seed();
            this.biomes.addAll(value.attributedBiomes());
            this.temperatureConfig = value.temperatureConfig();
            this.humidityConfig = value.humidityConfig();
            this.altitudeConfig = value.altitudeConfig();
            this.weirdnessConfig = value.weirdnessConfig();
            return this;
        }

        @Override
        public MultiNoiseBiomeConfig.Builder reset() {
            this.biomes.clear();
            this.seed = BootstrapProperties.worldGenSettings.seed();
            MultiNoiseBiomeSource.NoiseParameters defaultNoise = MultiNoiseBiomeSourceAccessor.accessor$DEFAULT_NOISE_PARAMETERS();
            this.temperatureConfig = (MultiNoiseConfig)defaultNoise;
            this.humidityConfig = (MultiNoiseConfig)defaultNoise;
            this.altitudeConfig = (MultiNoiseConfig)defaultNoise;
            this.weirdnessConfig = (MultiNoiseConfig)defaultNoise;
            return this;
        }

        public @NonNull MultiNoiseBiomeConfig build() {
            if (this.biomes.isEmpty()) {
                throw new IllegalStateException("MultiNoise biome config requires at least one biome!");
            }
            return new SpongeMultiNoiseBiomeConfig(this);
        }
    }

    public static final class FactoryImpl
    implements MultiNoiseBiomeConfig.Factory {
        @Override
        public MultiNoiseBiomeConfig nether() {
            return (MultiNoiseBiomeConfig)new BuilderImpl().addBiomes(Lists.newArrayList((Object[])new AttributedBiome[]{AttributedBiome.of(Biomes.NETHER_WASTES, BiomeAttributes.of(0.0f, 0.0f, 0.0f, 0.0f, 0.0f)), AttributedBiome.of(Biomes.SOUL_SAND_VALLEY, BiomeAttributes.of(0.0f, -0.5f, 0.0f, 0.0f, 0.0f)), AttributedBiome.of(Biomes.CRIMSON_FOREST, BiomeAttributes.of(0.4f, 0.0f, 0.0f, 0.0f, 0.0f)), AttributedBiome.of(Biomes.WARPED_FOREST, BiomeAttributes.of(0.0f, 0.5f, 0.0f, 0.0f, 0.375f)), AttributedBiome.of(Biomes.BASALT_DELTAS, BiomeAttributes.of(-0.5f, 0.0f, 0.0f, 0.0f, 0.175f))})).build();
        }
    }
}

