/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config;

import java.util.Objects;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.api.world.generation.config.structure.StructureGenerationConfig;
import org.spongepowered.common.accessor.world.level.levelgen.NoiseGeneratorSettingsAccessor;

public final class SpongeNoiseGeneratorConfig {

    public static final class FactoryImpl
    implements NoiseGeneratorConfig.Factory {
        @Override
        public NoiseGeneratorConfig amplified() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.AMPLIFIED);
        }

        @Override
        public NoiseGeneratorConfig overworld() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.OVERWORLD);
        }

        @Override
        public NoiseGeneratorConfig nether() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.NETHER);
        }

        @Override
        public NoiseGeneratorConfig end() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.END);
        }

        @Override
        public NoiseGeneratorConfig caves() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.CAVES);
        }

        @Override
        public NoiseGeneratorConfig floatingIslands() {
            return (NoiseGeneratorConfig)BuiltinRegistries.NOISE_GENERATOR_SETTINGS.get(NoiseGeneratorSettings.FLOATING_ISLANDS);
        }
    }

    public static final class BuilderImpl
    implements NoiseGeneratorConfig.Builder {
        public StructureGenerationConfig structureConfig;
        public NoiseConfig noiseConfig;
        public org.spongepowered.api.block.BlockState defaultBlock;
        public org.spongepowered.api.block.BlockState defaultFluid;
        public int bedrockRoofY;
        public int bedrockFloorY;
        public int seaLevel;
        public int minSurfaceLevel;
        public boolean aquifers;
        public boolean noiseCaves;
        public boolean deepslate;
        public boolean oreVeins;
        public boolean noodleCaves;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseGeneratorConfig.Builder structureConfig(StructureGenerationConfig config) {
            this.structureConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder noiseConfig(NoiseConfig config) {
            this.noiseConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder defaultBlock(org.spongepowered.api.block.BlockState block) {
            this.defaultBlock = Objects.requireNonNull(block, "block");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder defaultFluid(org.spongepowered.api.block.BlockState fluid) {
            this.defaultFluid = Objects.requireNonNull(fluid, "fluid");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder bedrockRoofY(int y) {
            this.bedrockRoofY = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder bedrockFloorY(int y) {
            this.bedrockFloorY = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder seaLevel(int y) {
            this.seaLevel = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder minSurfaceLevel(int y) {
            this.minSurfaceLevel = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder aquifers(boolean enableAquifers) {
            this.aquifers = enableAquifers;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder noiseCaves(boolean enableNoiseCaves) {
            this.noiseCaves = enableNoiseCaves;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder deepslate(boolean enableDeepslate) {
            this.deepslate = enableDeepslate;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder oreVeins(boolean enableOreVeins) {
            this.oreVeins = enableOreVeins;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder noodleCaves(boolean noodleCaves) {
            this.noodleCaves = noodleCaves;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder reset() {
            this.structureConfig = (StructureGenerationConfig)new StructureSettings(true);
            this.noiseConfig = NoiseConfig.overworld();
            this.defaultBlock = (org.spongepowered.api.block.BlockState)BlockTypes.STONE.get().defaultState();
            this.defaultFluid = (org.spongepowered.api.block.BlockState)BlockTypes.WATER.get().defaultState();
            this.bedrockRoofY = -10;
            this.bedrockFloorY = 0;
            this.seaLevel = 63;
            this.aquifers = false;
            this.noiseCaves = false;
            this.deepslate = false;
            this.oreVeins = false;
            this.noodleCaves = false;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder from(NoiseGeneratorConfig value) {
            this.structureConfig = value.structureConfig();
            this.noiseConfig = value.noiseConfig();
            this.defaultBlock = value.defaultBlock();
            this.defaultFluid = value.defaultFluid();
            this.bedrockRoofY = value.bedrockRoofY();
            this.bedrockFloorY = value.bedrockFloorY();
            this.seaLevel = value.seaLevel();
            this.aquifers = value.aquifers();
            this.noiseCaves = value.noiseCaves();
            this.deepslate = value.deepslate();
            this.deepslate = value.oreVeins();
            return this;
        }

        public NoiseGeneratorConfig build() {
            NoiseGeneratorSettings settings = NoiseGeneratorSettingsAccessor.invoker$new((StructureSettings)this.structureConfig, (NoiseSettings)this.noiseConfig, (BlockState)this.defaultBlock, (BlockState)this.defaultFluid, this.bedrockRoofY, this.bedrockFloorY, this.seaLevel, this.minSurfaceLevel, false, this.aquifers, this.noiseCaves, this.deepslate, this.oreVeins, this.noodleCaves);
            return (NoiseGeneratorConfig)settings;
        }
    }
}

