/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.structure;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StrongholdConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.generation.config.structure.SeparatedStructureConfig;
import org.spongepowered.api.world.generation.config.structure.SpacedStructureConfig;
import org.spongepowered.api.world.generation.config.structure.StructureGenerationConfig;
import org.spongepowered.api.world.generation.structure.Structure;

public final class SpongeStructureGenerationConfig {

    public static final class FactoryImpl
    implements StructureGenerationConfig.Factory {
        @Override
        public StructureGenerationConfig standard() {
            return (StructureGenerationConfig)new StructureSettings(true);
        }

        @Override
        public StructureGenerationConfig flat() {
            return (StructureGenerationConfig)new StructureSettings(Optional.of(StructureSettings.DEFAULT_STRONGHOLD), (Map)Maps.newHashMap((Map)ImmutableMap.of((Object)StructureFeature.VILLAGE, (Object)((StructureFeatureConfiguration)StructureSettings.DEFAULTS.get((Object)StructureFeature.VILLAGE)))));
        }

        @Override
        public StructureGenerationConfig none() {
            return (StructureGenerationConfig)new StructureSettings(Optional.empty(), new HashMap());
        }
    }

    public static final class BuilderImpl
    implements StructureGenerationConfig.Builder {
        public @Nullable SpacedStructureConfig stronghold;
        public final Map<Structure, SeparatedStructureConfig> structures = new Object2ObjectOpenHashMap();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public StructureGenerationConfig.Builder stronghold(@Nullable SpacedStructureConfig config) {
            this.stronghold = config;
            return this;
        }

        @Override
        public StructureGenerationConfig.Builder addStructure(Structure structure, SeparatedStructureConfig config) {
            this.structures.put(Objects.requireNonNull(structure, "structure"), Objects.requireNonNull(config, "config"));
            return this;
        }

        @Override
        public StructureGenerationConfig.Builder addStructures(Map<Structure, SeparatedStructureConfig> structures) {
            this.structures.putAll(Objects.requireNonNull(structures, "structures"));
            return this;
        }

        @Override
        public StructureGenerationConfig.Builder removeStructure(Structure structure) {
            this.structures.remove(Objects.requireNonNull(structure, "structure"));
            return this;
        }

        @Override
        public StructureGenerationConfig.Builder reset() {
            this.stronghold = null;
            this.structures.clear();
            return this;
        }

        @Override
        public StructureGenerationConfig.Builder from(StructureGenerationConfig value) {
            this.stronghold = value.stronghold().orElse(null);
            this.structures.clear();
            this.structures.putAll(value.structures());
            return this;
        }

        public @NonNull StructureGenerationConfig build() {
            return (StructureGenerationConfig)new StructureSettings(Optional.ofNullable((StrongholdConfiguration)this.stronghold), this.structures);
        }
    }
}

