/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.teleport;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;

public class DefaultTeleportHelperFilter
implements TeleportHelperFilter {
    private static final Set<Material> NOT_SAFE_FLOOR = ImmutableSet.of((Object)Material.AIR, (Object)Material.CACTUS, (Object)Material.FIRE, (Object)Material.LAVA);

    @Override
    public boolean isSafeFloorMaterial(org.spongepowered.api.block.BlockState blockState) {
        return !NOT_SAFE_FLOOR.contains(((BlockState)blockState).getMaterial());
    }

    @Override
    public boolean isSafeBodyMaterial(org.spongepowered.api.block.BlockState blockState) {
        BlockState state = (BlockState)blockState;
        Material material = state.getMaterial();
        if (state.isSuffocating((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
            return false;
        }
        if (material == Material.LAVA) {
            return false;
        }
        return !(state.getBlock() instanceof SlabBlock) && !(state.getBlock() instanceof CauldronBlock) && !(state.getBlock() instanceof AnvilBlock) && !(state.getBlock() instanceof FenceBlock) && !(state.getBlock() instanceof ChorusPlantBlock) && !(state.getBlock() instanceof SnowLayerBlock) && material != Material.GLASS && material != Material.LEAVES;
    }
}

