/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.plugin;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.PluginResourceLocatorService;
import org.spongepowered.plugin.blackboard.Key;
import org.spongepowered.plugin.blackboard.Keys;
import org.spongepowered.plugin.builtin.StandardEnvironment;
import org.spongepowered.plugin.builtin.jvm.JVMKeys;

public final class VanillaPluginPlatform
implements PluginPlatform {
    public static final Key<List<Path>> EXTRA_TRANSFORMABLE_PATHS = Key.of((String)"spongevanilla:transformable_paths", List.class);
    private final StandardEnvironment standardEnvironment;
    private final Map<String, PluginResourceLocatorService<PluginResource>> locatorServices;
    private final Map<String, PluginLanguageService<PluginResource>> languageServices;
    private final Map<String, Set<PluginResource>> locatorResources;
    private final Map<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>> pluginCandidates;

    public VanillaPluginPlatform(StandardEnvironment standardEnvironment) {
        this.standardEnvironment = standardEnvironment;
        this.locatorServices = new HashMap<String, PluginResourceLocatorService<PluginResource>>();
        this.languageServices = new HashMap<String, PluginLanguageService<PluginResource>>();
        this.locatorResources = new HashMap<String, Set<PluginResource>>();
        this.pluginCandidates = new IdentityHashMap<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>>();
    }

    @Override
    public String version() {
        return (String)this.standardEnvironment.blackboard().get(Keys.VERSION);
    }

    @Override
    public void setVersion(String version) {
        this.standardEnvironment.blackboard().getOrCreate(Keys.VERSION, () -> version);
    }

    @Override
    public Logger logger() {
        return this.standardEnvironment.logger();
    }

    @Override
    public Path baseDirectory() {
        return (Path)this.standardEnvironment.blackboard().get(Keys.BASE_DIRECTORY);
    }

    @Override
    public void setBaseDirectory(Path baseDirectory) {
        this.standardEnvironment.blackboard().getOrCreate(Keys.BASE_DIRECTORY, () -> baseDirectory);
    }

    @Override
    public List<Path> pluginDirectories() {
        return (List)this.standardEnvironment.blackboard().get(Keys.PLUGIN_DIRECTORIES);
    }

    @Override
    public void setPluginDirectories(List<Path> pluginDirectories) {
        this.standardEnvironment.blackboard().getOrCreate(Keys.PLUGIN_DIRECTORIES, () -> pluginDirectories);
    }

    @Override
    public String metadataFilePath() {
        return (String)this.standardEnvironment.blackboard().get(JVMKeys.METADATA_FILE_PATH);
    }

    @Override
    public void setMetadataFilePath(String metadataFilePath) {
        this.standardEnvironment.blackboard().getOrCreate(JVMKeys.METADATA_FILE_PATH, () -> metadataFilePath);
    }

    public StandardEnvironment getStandardEnvironment() {
        return this.standardEnvironment;
    }

    public Map<String, PluginResourceLocatorService<PluginResource>> getLocatorServices() {
        return Collections.unmodifiableMap(this.locatorServices);
    }

    public Map<String, PluginLanguageService<PluginResource>> getLanguageServices() {
        return Collections.unmodifiableMap(this.languageServices);
    }

    public Map<String, Set<PluginResource>> getResources() {
        return Collections.unmodifiableMap(this.locatorResources);
    }

    public Map<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>> getCandidates() {
        return Collections.unmodifiableMap(this.pluginCandidates);
    }

    public void initialize() {
        for (Map.Entry<String, PluginLanguageService<PluginResource>> entry : this.languageServices.entrySet()) {
            entry.getValue().initialize((Environment)this.standardEnvironment);
        }
    }

    public void discoverLocatorServices() {
        ServiceLoader<PluginResourceLocatorService> serviceLoader = ServiceLoader.load(PluginResourceLocatorService.class, null);
        Iterator<PluginResourceLocatorService> iter = serviceLoader.iterator();
        while (iter.hasNext()) {
            PluginResourceLocatorService next;
            try {
                next = iter.next();
            }
            catch (ServiceConfigurationError e) {
                this.standardEnvironment.logger().error("Error encountered initializing plugin resource locator!", (Throwable)e);
                continue;
            }
            this.locatorServices.put(next.name(), (PluginResourceLocatorService<PluginResource>)next);
        }
    }

    public void discoverLanguageServices() {
        ServiceLoader<PluginLanguageService> serviceLoader = ServiceLoader.load(PluginLanguageService.class, VanillaPluginPlatform.class.getClassLoader());
        Iterator<PluginLanguageService> iter = serviceLoader.iterator();
        while (iter.hasNext()) {
            PluginLanguageService next;
            try {
                next = iter.next();
            }
            catch (ServiceConfigurationError e) {
                this.standardEnvironment.logger().error("Error encountered initializing plugin language service!", (Throwable)e);
                continue;
            }
            this.languageServices.put(next.name(), (PluginLanguageService<PluginResource>)next);
        }
    }

    public void locatePluginResources() {
        for (Map.Entry<String, PluginResourceLocatorService<PluginResource>> locatorEntry : this.locatorServices.entrySet()) {
            PluginResourceLocatorService<PluginResource> locatorService = locatorEntry.getValue();
            Set resources = locatorService.locatePluginResources((Environment)this.standardEnvironment);
            if (resources.isEmpty()) continue;
            this.locatorResources.put(locatorEntry.getKey(), resources);
        }
    }

    public void createPluginCandidates() {
        for (Map.Entry<String, PluginLanguageService<PluginResource>> languageEntry : this.languageServices.entrySet()) {
            PluginLanguageService<PluginResource> languageService = languageEntry.getValue();
            for (Map.Entry<String, Set<PluginResource>> resourcesEntry : this.locatorResources.entrySet()) {
                for (PluginResource pluginResource : resourcesEntry.getValue()) {
                    try {
                        List candidates = languageService.createPluginCandidates((Environment)this.standardEnvironment, pluginResource);
                        if (candidates.isEmpty()) continue;
                        this.pluginCandidates.computeIfAbsent(languageService, k -> new LinkedList()).addAll(candidates);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

