/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.PlayerChatFormatter;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.vanilla.chat.ChatFormatter;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin_Vanilla
implements ServerGamePacketListener {
    @Shadow
    public net.minecraft.server.level.ServerPlayer player;
    @Shadow
    @Final
    private MinecraftServer server;

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")})
    private void vanilla$onHandleCustomPayload(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        packet.getData().retain();
        SpongeChannelManager channelRegistry = (SpongeChannelManager)Sponge.channelManager();
        this.server.execute(() -> channelRegistry.handlePlayPayload((EngineConnection)((Object)this), packet));
    }

    @Inject(method={"handleChat(Lnet/minecraft/server/network/TextFilter$FilteredText;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastMessage(Lnet/minecraft/network/chat/Component;Ljava/util/function/Function;Lnet/minecraft/network/chat/ChatType;Ljava/util/UUID;)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void vanilla$onProcessChatMessage(TextFilter.FilteredText message, CallbackInfo ci, String plain, String filteredPlain, net.minecraft.network.chat.Component filtered, net.minecraft.network.chat.Component unfiltered) {
        ChatFormatter.formatChatComponent((TranslatableComponent)unfiltered);
        ServerPlayer player = (ServerPlayer)this.player;
        PlayerChatFormatter chatFormatter = player.chatFormatter();
        TextComponent rawMessage = Component.text((String)plain);
        try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
            frame.pushCause(this.player);
            Audience audience = (Audience)this.server;
            PlayerChatEvent event = SpongeEventFactory.createPlayerChatEvent(frame.currentCause(), audience, Optional.of(audience), chatFormatter, Optional.of(chatFormatter), (Component)rawMessage, (Component)rawMessage);
            if (SpongeCommon.post(event)) {
                ci.cancel();
            } else {
                event.chatFormatter().ifPresent(formatter -> event.audience().map(SpongeAdventure::unpackAudiences).ifPresent(targets -> {
                    for (Audience target : targets) {
                        formatter.format(player, target, event.message(), event.originalMessage()).ifPresent(formattedMessage -> target.sendMessage((Identified)player, formattedMessage));
                    }
                }));
            }
        }
    }

    @Redirect(method={"handleChat(Lnet/minecraft/server/network/TextFilter$FilteredText;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastMessage(Lnet/minecraft/network/chat/Component;Ljava/util/function/Function;Lnet/minecraft/network/chat/ChatType;Ljava/util/UUID;)V"))
    private void vanilla$cancelSendChatMsgImpl(PlayerList playerList, net.minecraft.network.chat.Component p_232641_1_, Function<ServerPlayer, Component> messageProvider, ChatType p_232641_2_, UUID p_232641_3_) {
    }

    @Redirect(method={"lambda$handlePlaceRecipe$11"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/RecipeBookMenu;handlePlacement(ZLnet/minecraft/world/item/crafting/Recipe;Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void vanilla$onPlaceRecipe(RecipeBookMenu recipeBookMenu, boolean shift, Recipe<?> recipe, net.minecraft.server.level.ServerPlayer player) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        Inventory craftInv = ((Inventory)player.containerMenu).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            recipeBookMenu.handlePlacement(shift, recipe, player);
            SpongeCommon.logger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        try (EffectTransactor ignored = transactor.logPlaceRecipe(shift, recipe, player, (CraftingInventory)craftInv);){
            recipeBookMenu.handlePlacement(shift, recipe, player);
            player.containerMenu.broadcastChanges();
        }
    }
}

