/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class ThreadIdToken
implements Token {
    ThreadIdToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.THREAD);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        Thread thread = logEntry.getThread();
        builder.append(thread == null ? "?" : Long.valueOf(thread.getId()));
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        Thread thread = logEntry.getThread();
        if (thread == null) {
            statement.setNull(index, -5);
        } else {
            statement.setLong(index, thread.getId());
        }
    }
}

