/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity.living.player;

import java.time.Instant;
import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.entity.Tamer;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.math.vector.Vector3d;

@DoNotStore
public interface User
extends DataHolder.Mutable,
ArmorEquipable,
Tamer,
Subject,
Carrier {
    public GameProfile profile();

    @Override
    public String name();

    public boolean isOnline();

    public Optional<ServerPlayer> player();

    public Vector3d position();

    public ResourceKey worldKey();

    public boolean setLocation(ResourceKey var1, Vector3d var2);

    public void setRotation(Vector3d var1);

    public Vector3d rotation();

    @Override
    public CarriedInventory<? extends Carrier> inventory();

    public Inventory enderChestInventory();

    default public MapValue.Mutable<ResourceKey, RespawnLocation> respawnLocations() {
        return this.requireValue(Keys.RESPAWN_LOCATIONS).asMutable();
    }

    default public Optional<Value.Mutable<Instant>> firstJoined() {
        return this.getValue(Keys.FIRST_DATE_JOINED).map(Value::asMutable);
    }

    default public Optional<Value.Mutable<Instant>> lastJoined() {
        return this.getValue(Keys.LAST_DATE_JOINED).map(Value::asMutable);
    }

    default public Value.Mutable<Boolean> invulnerable() {
        return this.requireValue(Keys.INVULNERABLE).asMutable();
    }

    default public Value.Mutable<Boolean> invisible() {
        return this.requireValue(Keys.IS_INVISIBLE).asMutable();
    }

    default public Value.Mutable<VanishState> vanishState() {
        return this.requireValue(Keys.VANISH_STATE).asMutable();
    }

    @Deprecated
    default public Value.Mutable<Boolean> vanish() {
        return this.requireValue(Keys.VANISH).asMutable();
    }

    @Deprecated
    default public Value.Mutable<Boolean> vanishIgnoresCollision() {
        return this.requireValue(Keys.VANISH_IGNORES_COLLISION).asMutable();
    }

    @Deprecated
    default public Value.Mutable<Boolean> vanishPreventsTargeting() {
        return this.requireValue(Keys.VANISH_PREVENTS_TARGETING).asMutable();
    }
}

