/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.cooking;

import java.util.Objects;
import java.util.StringJoiner;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;

public final class CookingResult {
    private final ItemStackSnapshot result;
    private final double experience;

    public CookingResult(ItemStackSnapshot result, double experience) {
        Objects.requireNonNull(result, "result");
        if (result.isEmpty()) {
            throw new IllegalArgumentException("The resulting snapshot must not be empty");
        }
        if (experience < 0.0) {
            throw new IllegalArgumentException("The experience must be non-negative.");
        }
        this.result = result;
        this.experience = experience;
    }

    public ItemStackSnapshot result() {
        return this.result;
    }

    public double experience() {
        return this.experience;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CookingResult)) {
            return false;
        }
        CookingResult that = (CookingResult)o;
        return Double.compare(that.experience, this.experience) == 0 && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.experience);
    }

    public String toString() {
        return new StringJoiner(", ", CookingResult.class.getSimpleName() + "[", "]").add("result=" + this.result).add("experience=" + this.experience).toString();
    }
}

