/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.multi;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.common.command.parameter.multi.SpongeFirstOfParameter;

public final class SpongeFirstOfParameterBuilder
implements Parameter.FirstOfBuilder {
    private boolean isTerminal;
    private boolean isOptional;
    private final List<Parameter> parameterList = new ArrayList<Parameter>();

    @Override
    public @NonNull Parameter.FirstOfBuilder terminal() {
        this.isTerminal = true;
        return this;
    }

    @Override
    public @NonNull Parameter.FirstOfBuilder optional() {
        this.isOptional = true;
        return this;
    }

    @Override
    public @NonNull Parameter.FirstOfBuilder or(@NonNull Parameter parameter) {
        this.parameterList.add(parameter);
        return this;
    }

    @Override
    public @NonNull Parameter.Multi build() {
        Preconditions.checkState((!this.parameterList.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one parameter!");
        return new SpongeFirstOfParameter(this.parameterList, this.isOptional, this.isTerminal);
    }

    @Override
    public @NonNull Parameter.FirstOfBuilder reset() {
        this.isTerminal = false;
        this.isOptional = false;
        this.parameterList.clear();
        return this;
    }
}

