/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.fixer;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class CombineMapsCodec<A, B>
extends MapCodec<A> {
    private final MapCodec<A> first;
    private final Codec<B> second;
    private final BiFunction<A, B, A> decodeAction;
    private final Function<A, B> encodeAction;

    public <T> CombineMapsCodec(Codec<A> first, Codec<B> second, BiFunction<A, B, A> decodeAction, Function<A, B> encodeAction) {
        this.first = ((MapCodec.MapCodecCodec)first).codec();
        this.second = second;
        this.decodeAction = decodeAction;
        this.encodeAction = encodeAction;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        Stream keys = this.first.keys(ops);
        return Stream.concat(keys, Stream.of(ops.createString(this.mergeKey())));
    }

    public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult firstResult = this.first.decode(ops, input);
        if (!firstResult.result().isPresent()) {
            return firstResult;
        }
        Object rawSecondData = input.get(this.mergeKey());
        if (rawSecondData == null) {
            return firstResult;
        }
        DataResult secondResult = this.second.decode(ops, rawSecondData);
        if (!secondResult.result().isPresent()) {
            return firstResult;
        }
        return firstResult.map(val -> this.decodeAction.apply(val, ((Pair)secondResult.result().get()).getFirst()));
    }

    public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        RecordBuilder firstResult = this.first.encode(input, ops, prefix);
        DataResult secondResult = this.second.encode(this.encodeAction.apply(input), ops, null);
        firstResult.add(this.mergeKey(), secondResult);
        return firstResult;
    }

    protected abstract String mergeKey();
}

