/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class BookItemStackData {
    private BookItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.AUTHOR).get(h -> {
            CompoundTag tag = h.getTag();
            if (tag == null) {
                return null;
            }
            return LegacyComponentSerializer.legacySection().deserialize(tag.getString("author"));
        })).set((h, v) -> h.addTagElement("author", (Tag)StringTag.valueOf((String)LegacyComponentSerializer.legacySection().serialize(v))))).supports(h -> h.getItem() == Items.WRITTEN_BOOK)).create(Keys.GENERATION).get(h -> {
            CompoundTag tag = h.getTag();
            if (tag == null) {
                return null;
            }
            return tag.getInt("generation");
        })).setAnd((h, v) -> {
            if (v < 0) {
                return false;
            }
            h.addTagElement("generation", (Tag)IntTag.valueOf((int)v));
            return true;
        })).supports(h -> h.getItem() == Items.WRITTEN_BOOK)).create(Keys.PAGES).get(h -> BookItemStackData.get(h, iv -> GsonComponentSerializer.gson().deserialize(iv)))).setAnd((h, v) -> BookItemStackData.set(h, v, ih -> (String)GsonComponentSerializer.gson().serialize(ih)))).deleteAnd(BookItemStackData::delete)).supports(h -> h.getItem() == Items.WRITTEN_BOOK)).create(Keys.PLAIN_PAGES).get(h -> BookItemStackData.get(h, iv -> iv))).setAnd((h, v) -> BookItemStackData.set(h, v, iv -> iv))).deleteAnd(BookItemStackData::delete)).supports(h -> h.getItem() == Items.WRITABLE_BOOK);
    }

    private static <V> List<V> get(ItemStack holder, Function<String, V> predicate) {
        CompoundTag tag = holder.getTag();
        if (tag == null || !tag.contains("pages")) {
            return null;
        }
        ListTag list = tag.getList("pages", 8);
        return list.stream().map(Tag::getAsString).map(predicate).collect(Collectors.toList());
    }

    private static <V> boolean set(ItemStack holder, List<V> value, Function<V, String> predicate) {
        ListTag list = value.stream().map(predicate).collect(NBTCollectors.toStringTagList());
        holder.addTagElement("pages", (Tag)list);
        CompoundTag compound = holder.getOrCreateTag();
        if (!compound.contains("title")) {
            compound.putString("title", "invalid");
        }
        if (!compound.contains("author")) {
            compound.putString("author", "invalid");
        }
        compound.putBoolean("resolved", true);
        return false;
    }

    private static boolean delete(ItemStack holder) {
        CompoundTag tag = holder.getTag();
        if (tag != null && tag.contains("pages", 9)) {
            tag.remove("pages");
            return true;
        }
        return false;
    }
}

