/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;

final class ReverseDeepIterator
implements Iterator<GameTransaction<?>> {
    private GameTransaction<@NonNull ?> parent;
    private boolean hasScannedParent = false;
    private Iterator<GameTransaction<@NonNull ?>> child;
    private @Nullable GameTransaction<@NonNull ?> previous;

    ReverseDeepIterator(GameTransaction<@NonNull ?> pointer) {
        this.parent = pointer;
        this.child = pointer.reverseChildIterator();
        if (this.child.hasNext()) {
            this.previous = this.child.next();
        }
        if (this.previous == null) {
            this.previous = pointer;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.previous != null) {
            return true;
        }
        if (this.child.hasNext()) {
            this.previous = this.child.next();
            return true;
        }
        if (!this.hasScannedParent) {
            this.previous = this.parent;
            this.hasScannedParent = true;
            return true;
        }
        if (this.parent.previous != null) {
            this.hasScannedParent = false;
            GameTransaction<@NonNull ?> previous = this.parent.previous;
            this.parent = previous;
            this.child = previous.reverseChildIterator();
            this.previous = this.child.hasNext() ? this.child.next() : previous;
            return true;
        }
        return false;
    }

    @Override
    public GameTransaction<@NonNull ?> next() {
        if (this.previous != null) {
            GameTransaction<@NonNull ?> next = this.previous;
            this.previous = null;
            return next;
        }
        if (this.hasNext()) {
            return this.next();
        }
        throw new NoSuchElementException("No GameTransaction left to go to");
    }
}

