/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.block.transaction.Operations;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.FluidTickContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.world.BlockChange;

class FluidTickPhaseState
extends LocationBasedTickPhaseState<FluidTickContext> {
    private final String desc;

    FluidTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Tick", name, this);
    }

    @Override
    public FluidTickContext createNewContext(PhaseTracker tracker) {
        return new FluidTickContext(this, tracker);
    }

    @Override
    public boolean shouldProvideModifiers(FluidTickContext phaseContext) {
        return phaseContext.providesModifier;
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(FluidTickContext phaseContext, BlockState newState, BlockState currentState) {
        Block newBlock = newState.getBlock();
        if (phaseContext.tickingBlock.getType() instanceof FlowingFluid) {
            if (newBlock == Blocks.AIR) {
                return BlockChange.BREAK;
            }
            if (currentState.getBlock() instanceof LiquidBlock) {
                if (newBlock instanceof LiquidBlock) {
                    return BlockChange.MODIFY;
                }
                if (newState.isAir()) {
                    return BlockChange.DECAY;
                }
                return BlockChange.PLACE;
            }
            if (currentState.isAir() && newBlock instanceof LiquidBlock) {
                return BlockChange.PLACE;
            }
        }
        return super.associateBlockChangeWithSnapshot(phaseContext, newState, currentState);
    }

    @Override
    public Operation getBlockOperation(FluidTickContext phaseContext, SpongeBlockSnapshot original, SpongeBlockSnapshot result) {
        FluidState fluidState = original.state().fluidState();
        if (!fluidState.isEmpty() && result.blockChange == BlockChange.DECAY) {
            return Operations.LIQUID_DECAY.get();
        }
        if (fluidState.isEmpty() && result.blockChange == BlockChange.PLACE) {
            return Operations.LIQUID_SPREAD.get();
        }
        if (!fluidState.isEmpty() && result.blockChange == BlockChange.MODIFY) {
            return Operations.LIQUID_SPREAD.get();
        }
        return super.getBlockOperation(phaseContext, original, result);
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

