/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.EmptyInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.ViewableInventory;

public class EmptyInventoryImpl
implements EmptyInventory {
    private final Inventory parent;

    public EmptyInventoryImpl(@Nullable Inventory parent) {
        this.parent = parent == null ? this : parent;
    }

    @Override
    public List<Slot> slots() {
        return Collections.emptyList();
    }

    @Override
    public InventoryTransactionResult.Poll poll() {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).poll(ItemStackSnapshot.empty()).build();
    }

    @Override
    public InventoryTransactionResult.Poll poll(int limit) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).poll(ItemStackSnapshot.empty()).build();
    }

    @Override
    public ItemStack peek() {
        return ItemStack.empty();
    }

    @Override
    public List<Inventory> children() {
        return Collections.emptyList();
    }

    @Override
    public void clear() {
    }

    @Override
    public int freeCapacity() {
        return 0;
    }

    @Override
    public int totalQuantity() {
        return 0;
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean contains(ItemStack stack) {
        return false;
    }

    @Override
    public boolean containsAny(ItemStack stack) {
        return false;
    }

    @Override
    public <V> Optional<V> get(Inventory child, Key<? extends Value<V>> key) {
        return Optional.empty();
    }

    @Override
    public <V> Optional<V> get(Key<? extends Value<V>> key) {
        return Optional.empty();
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        return false;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ImmutableSet.of();
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return ImmutableSet.of();
    }

    @Override
    public boolean contains(ItemType type) {
        return false;
    }

    @Override
    public Inventory query(KeyValueMatcher<?> matcher) {
        return this;
    }

    @Override
    public Inventory query(Query query) {
        return query.execute(this);
    }

    @Override
    public <T extends Inventory> Optional<T> query(Class<T> inventoryType) {
        if (EmptyInventory.class == inventoryType) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public Inventory intersect(Inventory inventory) {
        return this;
    }

    @Override
    public Inventory union(Inventory inventory) {
        return inventory;
    }

    @Override
    public boolean containsInventory(Inventory inventory) {
        return this == inventory;
    }

    @Override
    public Inventory parent() {
        return this.parent;
    }

    @Override
    public Inventory root() {
        return this.parent == this ? this : this.parent.root();
    }

    @Override
    public InventoryTransactionResult offer(ItemStack ... stacks) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(stacks).build();
    }

    @Override
    public InventoryTransactionResult.Poll pollFrom(int index) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).poll(ItemStackSnapshot.empty()).build();
    }

    @Override
    public InventoryTransactionResult.Poll pollFrom(int index, int limit) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).poll(ItemStackSnapshot.empty()).build();
    }

    @Override
    public Optional<ItemStack> peekAt(int index) {
        return Optional.empty();
    }

    @Override
    public InventoryTransactionResult offer(int index, ItemStack stack) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).reject(stack).build();
    }

    @Override
    public InventoryTransactionResult set(int index, ItemStack stack) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).reject(stack).build();
    }

    @Override
    public boolean canFit(ItemStack stack) {
        return false;
    }

    @Override
    public Optional<Slot> slot(int index) {
        return Optional.empty();
    }

    @Override
    public boolean containsChild(Inventory child) {
        return this == child;
    }

    @Override
    public Optional<ViewableInventory> asViewable() {
        return Optional.empty();
    }
}

