/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public abstract class SpongeRecipeRegistration
implements RecipeRegistration,
FinishedRecipe {
    protected final ResourceLocation key;
    protected final RecipeSerializer<?> serializer;
    protected final ResourceLocation advancementId;
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.advancement();
    protected final String group;

    public static <S extends RecipeSerializer<T>, T extends Recipe<?>> S register(String spongeName, S recipeSerializer) {
        return (S)((RecipeSerializer)Registry.register((Registry)Registry.RECIPE_SERIALIZER, (String)new ResourceLocation("sponge", spongeName).toString(), recipeSerializer));
    }

    public static <S extends RecipeSerializer<T>, T extends Recipe<?>> S register(ResourceLocation resourceLocation, S recipeSerializer) {
        return (S)((RecipeSerializer)Registry.register((Registry)Registry.RECIPE_SERIALIZER, (String)resourceLocation.toString(), recipeSerializer));
    }

    public SpongeRecipeRegistration(ResourceLocation key, RecipeSerializer<?> serializer, Item resultItem, String group) {
        this.key = key;
        this.serializer = serializer;
        CreativeModeTab itemGroup = resultItem.getItemCategory();
        this.advancementId = new ResourceLocation(key.getNamespace(), "recipes/" + (itemGroup == null ? "uncategorized" : itemGroup.getRecipeFolderName()) + "/" + key.getPath());
        this.advancementBuilder.addCriterion("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.unlocked((ResourceLocation)key)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)key));
        this.group = group == null ? "" : group;
    }

    public static <C extends Container> RecipeSerializer<?> determineSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction, Map<Character, Ingredient> ingredients, RecipeSerializer<?> vanilla, RecipeSerializer<?> sponge) {
        return SpongeRecipeRegistration.determineSerializer(resultStack, resultFunction, remainingItemsFunction, ingredients.values(), vanilla, sponge);
    }

    public static <C extends Container> RecipeSerializer<?> determineSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction, Collection<Ingredient> ingredients, RecipeSerializer<?> vanilla, RecipeSerializer<?> sponge) {
        if (resultStack.hasTag() || resultFunction != null || remainingItemsFunction != null) {
            return sponge;
        }
        for (Ingredient value : ingredients) {
            if (!(value instanceof SpongeIngredient)) continue;
            return sponge;
        }
        return vanilla;
    }

    public ResourceLocation getId() {
        return this.key;
    }

    @Override
    public ResourceKey key() {
        return (ResourceKey)this.key;
    }

    public RecipeSerializer<?> getType() {
        return this.serializer;
    }

    public void serializeRecipeData(JsonObject json) {
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        this.serializeShape(json);
        this.serializeResult(json);
        this.serializeAdditional(json);
    }

    public abstract void serializeShape(JsonObject var1);

    public abstract void serializeResult(JsonObject var1);

    public void serializeAdditional(JsonObject json) {
    }

    public JsonObject serializeAdvancement() {
        return this.advancementBuilder.serializeToJson();
    }

    public ResourceLocation getAdvancementId() {
        return this.advancementId;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        try {
            return DataFormats.JSON.get().read(this.serializeRecipe().toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public DataPackType type() {
        return DataPackTypes.RECIPE;
    }
}

