/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.commands.arguments.selector;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.selector.Selector;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntitySelector.class})
public abstract class EntitySelectorMixin_API
implements Selector {
    @Shadow
    @Final
    private int maxResults;
    @Shadow
    @Final
    private boolean includesEntities;

    @Shadow
    public abstract List<? extends net.minecraft.world.entity.Entity> shadow$findEntities(CommandSourceStack var1) throws CommandSyntaxException;

    @Override
    public @NonNull Collection<Entity> select(@NonNull ServerLocation location) throws IllegalStateException {
        return this.api$select(((MinecraftServer)Sponge.server()).createCommandSourceStack().withLevel((ServerLevel)location.world()).withPosition(VecHelper.toVanillaVector3d(location.position())));
    }

    @Override
    public @NonNull Collection<Entity> select(@NonNull Entity entity) throws IllegalStateException {
        return this.api$select(((net.minecraft.world.entity.Entity)entity).createCommandSourceStack());
    }

    @Override
    public @NonNull Collection<Entity> select(@NonNull CommandCause cause) {
        return this.api$select((CommandSourceStack)cause);
    }

    @Override
    public int limit() {
        return this.maxResults;
    }

    @Override
    public boolean playersOnly() {
        return !this.includesEntities;
    }

    private Collection<Entity> api$select(@NonNull CommandSourceStack source) {
        try {
            return this.shadow$findEntities(source).stream().map(x -> (Entity)x).collect(Collectors.toList());
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException(commandSyntaxException.getMessage(), commandSyntaxException);
        }
    }
}

