/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.world.storage.MapItemSavedDataBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.math.vector.Vector2i;

@Mixin(value={EmptyMapItem.class})
public abstract class EmptyMapItemMixin {
    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/MapItem;create(Lnet/minecraft/world/level/Level;IIBZZ)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack impl$createMapWithSpongeData(Level level, int x, int y, byte scale, boolean trackingPosition, boolean unlimitedTracking, Level level2, Player playerIn, InteractionHand usedHand) {
        if (level.isClientSide()) {
            return MapItem.create((Level)level, (int)x, (int)y, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking);
        }
        org.spongepowered.api.entity.living.player.Player player = (org.spongepowered.api.entity.living.player.Player)playerIn;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.PLAYER, player);
            HandType handType = (HandType)usedHand;
            frame.addContext(EventContextKeys.USED_HAND, handType);
            frame.addContext(EventContextKeys.USED_ITEM, player.itemInHand(handType).createSnapshot());
            HashSet mapValues = Sets.newHashSet((Object[])new Value[]{Value.immutableOf(Keys.MAP_LOCATION, Vector2i.from((int)((int)playerIn.getX()), (int)((int)playerIn.getZ()))), Value.immutableOf(Keys.MAP_WORLD, ((ServerWorld)level).key()), Value.immutableOf(Keys.MAP_TRACKS_PLAYERS, Boolean.valueOf(trackingPosition)), Value.immutableOf(Keys.MAP_UNLIMITED_TRACKING, Boolean.valueOf(unlimitedTracking)), Value.immutableOf(Keys.MAP_SCALE, Integer.valueOf(scale))});
            Optional<MapInfo> optMapInfo = SpongeCommonEventFactory.fireCreateMapEvent(frame.currentCause(), mapValues);
            if (!optMapInfo.isPresent()) {
                ItemStack itemStack = ItemStack.EMPTY;
                return itemStack;
            }
            int id = ((MapItemSavedDataBridge)((Object)optMapInfo.get())).bridge$getMapId();
            ItemStack newMap = new ItemStack((ItemLike)Items.FILLED_MAP, 1);
            CompoundTag nbt = newMap.getOrCreateTag();
            nbt.putInt("map", id);
            ItemStack itemStack = newMap;
            return itemStack;
        }
    }

    @Inject(method={"use"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;isClientSide:Z", opcode=180)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void impl$returnFailResultIfMapWasNotCreated(Level level, Player playerIn, InteractionHand handIn, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir, ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            cir.cancel();
            cir.setReturnValue((Object)InteractionResultHolder.fail((Object)playerIn.getItemInHand(handIn)));
        }
    }
}

