/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.item;

import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.MinecraftFallingBlockDamageSource;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends EntityMixin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"lambda$causeFallDamage$0(Lnet/minecraft/world/damagesource/DamageSource;FLnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private static boolean impl$swapDamageSources(Entity entity, DamageSource source, float damage) {
        if (entity.level.isClientSide) {
            return entity.hurt(source, damage);
        }
        boolean isAnvil = source == DamageSource.ANVIL;
        boolean isFallingBlock = source == DamageSource.FALLING_BLOCK;
        boolean isStalactite = source == DamageSource.FALLING_STALACTITE;
        Optional<FallingBlockEntity> fallingBlockEntity = PhaseTracker.getInstance().getPhaseContext().getSource(FallingBlockEntity.class);
        try {
            if (isAnvil && fallingBlockEntity.isPresent()) {
                MinecraftFallingBlockDamageSource anvil = new MinecraftFallingBlockDamageSource("anvil", fallingBlockEntity.get());
                anvil.setDefaultFallingBlockDamage();
                ((DamageSourceBridge)((Object)anvil)).bridge$setAnvilSource();
                boolean bl = entity.hurt(DamageSource.ANVIL, damage);
                return bl;
            }
            if (isFallingBlock && fallingBlockEntity.isPresent()) {
                MinecraftFallingBlockDamageSource fallingblock = new MinecraftFallingBlockDamageSource("fallingblock", fallingBlockEntity.get());
                fallingblock.setDefaultFallingBlockDamage();
                ((DamageSourceBridge)((Object)fallingblock)).bridge$setFallingBlockSource();
                boolean bl = entity.hurt(DamageSource.FALLING_BLOCK, damage);
                return bl;
            }
            if (isStalactite && fallingBlockEntity.isPresent()) {
                MinecraftFallingBlockDamageSource stalactite = new MinecraftFallingBlockDamageSource("fallingStalactite", fallingBlockEntity.get());
                stalactite.setDefaultFallingBlockDamage();
                ((DamageSourceBridge)((Object)stalactite)).bridge$setFallingStalactite();
                boolean bl = entity.hurt(DamageSource.FALLING_STALACTITE, damage);
                return bl;
            }
            boolean bl = entity.hurt(source, damage);
            return bl;
        }
        finally {
            if (isAnvil) {
                ((DamageSourceBridge)source).bridge$setAnvilSource();
            } else if (isFallingBlock) {
                ((DamageSourceBridge)source).bridge$setFallingBlockSource();
            } else if (isStalactite) {
                ((DamageSourceBridge)source).bridge$setFallingStalactite();
            }
        }
    }
}

