/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.SerializableUUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.accessor.world.level.LevelSettingsAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.levelgen.WorldGenSettingsBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.data.fixer.LegacyUUIDCodec;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={PrimaryLevelData.class})
public abstract class PrimaryLevelDataMixin
implements WorldData,
PrimaryLevelDataBridge,
ResourceKeyBridge {
    @Shadow
    private LevelSettings settings;
    @Shadow
    private int xSpawn;
    @Shadow
    private int ySpawn;
    @Shadow
    private int zSpawn;
    @Shadow
    private float spawnAngle;
    private @Nullable ResourceKey impl$key;
    private DimensionType impl$dimensionType;
    private @Nullable SerializationBehavior impl$serializationBehavior;
    private @Nullable Component impl$displayName;
    private @Nullable Integer impl$viewDistance;
    private UUID impl$uniqueId = UUID.randomUUID();
    private Boolean impl$pvp;
    private InheritableConfigHandle<WorldConfig> impl$configAdapter;
    private final BiMap<Integer, UUID> impl$playerUniqueIdMap = HashBiMap.create();
    private final List<UUID> impl$pendingUniqueIds = new ArrayList<UUID>();
    private int impl$trackedUniqueIdCount = 0;
    private boolean impl$customDifficulty = false;
    private boolean impl$customGameType = false;
    private boolean impl$customSpawnPosition = false;
    private boolean impl$loadOnStartup;
    private boolean impl$performsSpawnLogic;
    private BiMap<Integer, UUID> impl$mapUUIDIndex = HashBiMap.create();

    @Shadow
    public abstract boolean shadow$isDifficultyLocked();

    @Shadow
    public abstract void shadow$setSpawn(BlockPos var1, float var2);

    @Override
    public ResourceKey bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void bridge$setKey(ResourceKey key) {
        this.impl$key = key;
    }

    @Override
    public boolean bridge$valid() {
        return this.impl$key != null;
    }

    @Override
    public @Nullable ServerLevel bridge$world() {
        if (!Sponge.isServerAvailable()) {
            return null;
        }
        ServerLevel world = SpongeCommon.server().getLevel(SpongeWorldManager.createRegistryKey(this.impl$key));
        if (world == null) {
            return null;
        }
        ServerLevelData levelData = (ServerLevelData)world.getLevelData();
        if (levelData != this) {
            return null;
        }
        return world;
    }

    @Override
    public DimensionType bridge$dimensionType() {
        return this.impl$dimensionType;
    }

    @Override
    public void bridge$dimensionType(DimensionType type, boolean updatePlayers) {
        this.impl$dimensionType = type;
    }

    @Override
    public UUID bridge$uniqueId() {
        return this.impl$uniqueId;
    }

    @Override
    public void bridge$setUniqueId(UUID uniqueId) {
        this.impl$uniqueId = uniqueId;
    }

    @Override
    public boolean bridge$customDifficulty() {
        return this.impl$customDifficulty;
    }

    @Override
    public boolean bridge$customGameType() {
        return this.impl$customGameType;
    }

    @Override
    public boolean bridge$customSpawnPosition() {
        return this.impl$customSpawnPosition;
    }

    @Override
    public void bridge$forceSetDifficulty(Difficulty difficulty) {
        this.impl$customDifficulty = true;
        ((LevelSettingsAccessor)this.settings).accessor$difficulty(difficulty);
        this.impl$updateWorldForDifficultyChange(this.bridge$world(), this.shadow$isDifficultyLocked());
    }

    @Override
    public Optional<Boolean> bridge$pvp() {
        return Optional.ofNullable(this.impl$pvp);
    }

    @Override
    public void bridge$setPvp(@Nullable Boolean pvp) {
        this.impl$pvp = pvp;
    }

    @Override
    public boolean bridge$performsSpawnLogic() {
        return this.impl$performsSpawnLogic;
    }

    @Override
    public void bridge$setPerformsSpawnLogic(boolean performsSpawnLogic) {
        this.impl$performsSpawnLogic = performsSpawnLogic;
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.impl$loadOnStartup;
    }

    @Override
    public void bridge$setLoadOnStartup(boolean loadOnStartup) {
        this.impl$loadOnStartup = loadOnStartup;
    }

    @Override
    public Optional<SerializationBehavior> bridge$serializationBehavior() {
        return Optional.ofNullable(this.impl$serializationBehavior);
    }

    @Override
    public void bridge$setSerializationBehavior(@Nullable SerializationBehavior behavior) {
        this.impl$serializationBehavior = behavior;
    }

    @Override
    public Optional<Component> bridge$displayName() {
        return Optional.ofNullable(this.impl$displayName);
    }

    @Override
    public void bridge$setDisplayName(@Nullable Component displayName) {
        this.impl$displayName = displayName;
    }

    @Override
    public Optional<Integer> bridge$viewDistance() {
        return Optional.ofNullable(this.impl$viewDistance);
    }

    @Override
    public void bridge$setViewDistance(@Nullable Integer viewDistance) {
        this.impl$viewDistance = viewDistance;
        ServerLevel world = this.bridge$world();
        if (world != null) {
            int actual = viewDistance == null ? BootstrapProperties.viewDistance : viewDistance;
            world.getChunkSource().setViewDistance(actual);
            ClientboundSetChunkCacheRadiusPacket packet = new ClientboundSetChunkCacheRadiusPacket(actual);
            world.players().forEach(p -> p.connection.send((Packet)packet));
        }
    }

    @Override
    public InheritableConfigHandle<WorldConfig> bridge$configAdapter() {
        return this.impl$configAdapter;
    }

    @Override
    public void bridge$configAdapter(InheritableConfigHandle<WorldConfig> adapter) {
        this.impl$configAdapter = adapter;
    }

    @Override
    public void bridge$populateFromDimension(LevelStem stem) {
        LevelStemBridge levelStemBridge = (LevelStemBridge)stem;
        this.impl$key = ((ResourceKeyBridge)stem).bridge$getKey();
        this.impl$dimensionType = stem.type();
        this.impl$displayName = levelStemBridge.bridge$displayName().orElse(null);
        levelStemBridge.bridge$difficulty().ifPresent(v -> {
            ((LevelSettingsAccessor)this.settings).accessor$difficulty((Difficulty)RegistryTypes.DIFFICULTY.get().value((ResourceKey)v));
            this.impl$customDifficulty = true;
        });
        levelStemBridge.bridge$gameMode().ifPresent(v -> {
            ((LevelSettingsAccessor)this.settings).accessor$gameType((GameType)RegistryTypes.GAME_MODE.get().value((ResourceKey)v));
            this.impl$customGameType = true;
        });
        levelStemBridge.bridge$spawnPosition().ifPresent(v -> {
            this.shadow$setSpawn(VecHelper.toBlockPos(v), this.spawnAngle);
            this.impl$customSpawnPosition = true;
        });
        levelStemBridge.bridge$hardcore().ifPresent(v -> ((LevelSettingsAccessor)this.settings).accessor$hardcode((boolean)v));
        this.impl$serializationBehavior = levelStemBridge.bridge$serializationBehavior().orElse(null);
        this.impl$pvp = levelStemBridge.bridge$pvp().orElse(null);
        this.impl$loadOnStartup = levelStemBridge.bridge$loadOnStartup();
        this.impl$performsSpawnLogic = levelStemBridge.bridge$performsSpawnLogic();
        this.impl$viewDistance = levelStemBridge.bridge$viewDistance().orElse(null);
    }

    @Override
    public void bridge$setMapUUIDIndex(BiMap<Integer, UUID> index) {
        this.impl$mapUUIDIndex = index;
    }

    @Override
    public BiMap<Integer, UUID> bridge$getMapUUIDIndex() {
        return this.impl$mapUUIDIndex;
    }

    @Override
    public int bridge$getIndexForUniqueId(UUID uuid) {
        Integer index = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)uuid);
        if (index != null) {
            return index;
        }
        this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount, (Object)uuid);
        this.impl$pendingUniqueIds.add(uuid);
        return this.impl$trackedUniqueIdCount++;
    }

    @Override
    public Optional<UUID> bridge$getUniqueIdForIndex(int index) {
        return Optional.ofNullable((UUID)this.impl$playerUniqueIdMap.get((Object)index));
    }

    public ServerLevelData overworldData() {
        if (Level.OVERWORLD.location().equals((Object)this.impl$key)) {
            return (ServerLevelData)this;
        }
        return (ServerLevelData)SpongeCommon.server().getLevel(Level.OVERWORLD).getLevelData();
    }

    @Redirect(method={"setTagData"}, at=@At(value="INVOKE", remap=false, target="Lcom/mojang/serialization/Codec;encodeStart(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", ordinal=0))
    private DataResult<Object> impl$ignorePluginDimensionsWhenWritingWorldGenSettings(Codec codec, DynamicOps<Object> ops, Object input) {
        WorldGenSettings dimensionGeneratorSettings = (WorldGenSettings)input;
        if (dimensionGeneratorSettings.dimensions().entrySet().size() == 0) {
            return codec.encodeStart(ops, (Object)dimensionGeneratorSettings);
        }
        dimensionGeneratorSettings = ((WorldGenSettingsBridge)input).bridge$copy();
        MappedRegistry registry = new MappedRegistry(net.minecraft.core.Registry.LEVEL_STEM_REGISTRY, Lifecycle.stable());
        ((Registry)dimensionGeneratorSettings.dimensions()).streamEntries().forEach(entry -> {
            if ("minecraft".equals(entry.key().namespace())) {
                ((Registry)registry).register(entry.key(), (LevelStem)entry.value());
            }
        });
        ((DimensionGeneratorSettingsAccessor)dimensionGeneratorSettings).accessor$dimensions((MappedRegistry<LevelStem>)registry);
        return codec.encodeStart(ops, (Object)dimensionGeneratorSettings);
    }

    void impl$updateWorldForDifficultyChange(ServerLevel world, boolean isLocked) {
        if (world == null) {
            return;
        }
        MinecraftServer server = world.getServer();
        Difficulty difficulty = ((LevelData)this).getDifficulty();
        if (difficulty == Difficulty.HARD) {
            world.setSpawnSettings(true, true);
        } else if (server.isSingleplayer()) {
            world.setSpawnSettings(difficulty != Difficulty.PEACEFUL, true);
        } else {
            world.setSpawnSettings(((MinecraftServerAccessor)server).invoker$isSpawningMonsters(), server.isSpawningAnimals());
        }
        world.players().forEach(player -> player.connection.send((Packet)new ClientboundChangeDifficultyPacket(difficulty, isLocked)));
    }

    @Override
    public void bridge$readSpongeLevelData(Dynamic<Tag> dynamic) {
        if (dynamic == null) {
            this.bridge$setUniqueId(UUID.randomUUID());
            return;
        }
        this.bridge$setUniqueId(dynamic.get("UUID").read((Decoder)SerializableUUID.CODEC).result().orElse(UUID.randomUUID()));
        List mapIndexList = dynamic.get("MapUUIDs").readMap((Decoder)Codec.STRING, (Decoder)SerializableUUID.CODEC).result().orElse(Collections.emptyList());
        HashBiMap mapIndex = HashBiMap.create();
        for (Pair pair : mapIndexList) {
            int id = Integer.parseInt((String)pair.getFirst());
            mapIndex.put((Object)id, (Object)((UUID)pair.getSecond()));
        }
        this.bridge$setMapUUIDIndex((BiMap<Integer, UUID>)mapIndex);
        dynamic.get("PlayerIdTable").readList(LegacyUUIDCodec.CODEC).result().orElseGet(() -> dynamic.get("player-uuid-table").readList((Decoder)SerializableUUID.CODEC).result().orElse(Collections.emptyList())).forEach(uuid -> {
            Integer playerIndex = (Integer)this.impl$playerUniqueIdMap.inverse().get(uuid);
            if (playerIndex == null) {
                this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount++, uuid);
            }
        });
    }

    @Override
    public CompoundTag bridge$writeSpongeLevelData() {
        CompoundTag data = new CompoundTag();
        data.putUUID("UUID", this.bridge$uniqueId());
        CompoundTag mapUUIDIndexTag = new CompoundTag();
        MapUtil.saveMapUUIDIndex(mapUUIDIndexTag, this.bridge$getMapUUIDIndex());
        data.put("MapUUIDs", (Tag)mapUUIDIndexTag);
        ListTag playerIdList = new ListTag();
        data.put("player-uuid-table", (Tag)playerIdList);
        this.impl$pendingUniqueIds.forEach(uuid -> playerIdList.add((Object)new IntArrayTag(SerializableUUID.uuidToIntArray((UUID)uuid))));
        this.impl$pendingUniqueIds.clear();
        return data;
    }

    public String toString() {
        return new StringJoiner(", ", PrimaryLevelData.class.getSimpleName() + "[", "]").add("key=" + this.impl$key).add("worldType=" + this.impl$dimensionType).add("uniqueId=" + this.impl$uniqueId).add("spawn=" + new Vector3i(this.xSpawn, this.ySpawn, this.zSpawn)).add("gameType=" + ((ServerLevelData)this).getGameType()).add("hardcore=" + ((LevelData)this).isHardcore()).add("difficulty=" + ((LevelData)this).getDifficulty()).toString();
    }
}

