/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class ServerPlayerGameModeMixin_Tracker {
    @Shadow
    @Final
    protected ServerPlayer player;
    @Shadow
    protected ServerLevel level;
    @Shadow
    private GameType gameModeForPlayer;

    @Shadow
    public abstract boolean isCreative();

    @Inject(method={"useItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getCount()I", ordinal=0)})
    public void impl$callInteractItemSecondary(ServerPlayer player, Level p_187250_2_, ItemStack stack, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractItemEvent.Secondary event = SpongeCommonEventFactory.callInteractItemEventSecondary((Player)player, stack, hand);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Overwrite
    public InteractionResult useItemOn(ServerPlayer playerIn, Level worldIn, ItemStack stackIn, InteractionHand handIn, BlockHitResult blockRaytraceResultIn) {
        InteractionResult result;
        Direction direction;
        BlockPos blockpos = blockRaytraceResultIn.getBlockPos();
        BlockState blockstate = worldIn.getBlockState(blockpos);
        BlockSnapshot snapshot = ((ServerWorld)worldIn).createSnapshot(VecHelper.toVector3i(blockpos));
        Vector3d hitVec = Vector3d.from((double)blockRaytraceResultIn.getBlockPos().getX(), (double)blockRaytraceResultIn.getBlockPos().getY(), (double)blockRaytraceResultIn.getBlockPos().getZ());
        InteractBlockEvent.Secondary event = SpongeCommonEventFactory.callInteractBlockEventSecondary((Player)playerIn, stackIn, hitVec, snapshot, direction = DirectionFacingProvider.INSTANCE.getKey(blockRaytraceResultIn.getDirection()).get(), handIn);
        if (event.isCancelled()) {
            return InteractionResult.FAIL;
        }
        Tristate useItem = event.useItemResult();
        Tristate useBlock = event.useBlockResult();
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider inamedcontainerprovider = blockstate.getMenuProvider(worldIn, blockpos);
            if (inamedcontainerprovider != null) {
                playerIn.openMenu(inamedcontainerprovider);
                Vector3i pos = VecHelper.toVector3i(blockRaytraceResultIn.getBlockPos());
                ServerLocation location = ServerLocation.of((ServerWorld)worldIn, pos);
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(playerIn);
                    frame.addContext(EventContextKeys.BLOCK_HIT, ((ServerWorld)worldIn).createSnapshot(pos));
                    ((ContainerBridge)playerIn.containerMenu).bridge$setOpenLocation(location);
                    if (!InventoryEventFactory.callInteractContainerOpenEvent(playerIn)) {
                        InteractionResult interactionResult = InteractionResult.SUCCESS;
                        return interactionResult;
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        boolean flag = !playerIn.getMainHandItem().isEmpty() || !playerIn.getOffhandItem().isEmpty();
        boolean flag1 = playerIn.isSecondaryUseActive() && flag;
        ItemStack copiedStack = stackIn.copy();
        if (useBlock != Tristate.FALSE && !flag1) {
            AbstractContainerMenu lastOpenContainer = playerIn.containerMenu;
            result = blockstate.use(worldIn, (Player)playerIn, handIn, blockRaytraceResultIn);
            if (result.consumesAction() && lastOpenContainer != playerIn.containerMenu) {
                Vector3i pos = VecHelper.toVector3i(blockRaytraceResultIn.getBlockPos());
                ServerLocation location = ServerLocation.of((ServerWorld)worldIn, pos);
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(playerIn);
                    frame.addContext(EventContextKeys.BLOCK_HIT, ((ServerWorld)worldIn).createSnapshot(pos));
                    ((ContainerBridge)playerIn.containerMenu).bridge$setOpenLocation(location);
                    if (!InventoryEventFactory.callInteractContainerOpenEvent(playerIn)) {
                        InteractionResult interactionResult = InteractionResult.FAIL;
                        return interactionResult;
                    }
                }
            }
            if (result.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(playerIn, blockpos, copiedStack);
                return result;
            }
        }
        if (!stackIn.isEmpty() && !playerIn.getCooldowns().isOnCooldown(stackIn.getItem())) {
            if (useItem == Tristate.FALSE) {
                return InteractionResult.PASS;
            }
            UseOnContext itemusecontext = new UseOnContext((Player)playerIn, handIn, blockRaytraceResultIn);
            if (this.isCreative()) {
                int i = stackIn.getCount();
                result = stackIn.useOn(itemusecontext);
                stackIn.setCount(i);
            } else {
                result = stackIn.useOn(itemusecontext);
                PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
                TransactionalCaptureSupplier transactor = context.getTransactor();
                transactor.logPlayerInventoryChange((Player)this.player, PlayerInventoryTransaction.EventCreator.STANDARD);
                this.player.inventoryMenu.broadcastChanges();
            }
            if (result.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(playerIn, blockpos, copiedStack);
            }
            return result;
        }
        return InteractionResult.PASS;
    }
}

