/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={DispenserBlock.class})
public abstract class DispenserBlockMixin_Tracker {
    private Supplier<ItemStack> tracker$originalItem = () -> ItemStack.EMPTY;
    private PhaseContext<?> tracker$context = PhaseContext.empty();

    @Inject(method={"dispenseFrom"}, at={@At(value="HEAD")})
    private void tracker$createContextOnDispensing(ServerLevel worldIn, BlockPos pos, CallbackInfo ci) {
        BlockState state = worldIn.getBlockState(pos);
        SpongeBlockSnapshot spongeBlockSnapshot = ((TrackedWorldBridge)worldIn).bridge$createSnapshot(state, pos, BlockChangeFlags.ALL);
        LevelChunkBridge mixinChunk = (LevelChunkBridge)worldIn.getChunkAt(pos);
        this.tracker$context = ((PhaseContext)((PhaseContext)((PhaseContext)((PhaseContext)BlockPhase.State.DISPENSE.createPhaseContext(PhaseTracker.SERVER)).source(spongeBlockSnapshot)).creator(() -> mixinChunk.bridge$getBlockCreatorUUID(pos))).notifier(() -> mixinChunk.bridge$getBlockNotifierUUID(pos))).buildAndSwitch();
    }

    @Inject(method={"dispenseFrom"}, at={@At(value="RETURN")})
    private void tracker$closeContextOnDispensing(ServerLevel worldIn, BlockPos pos, CallbackInfo ci) {
        this.tracker$context.close();
        this.tracker$context = PhaseContext.empty();
    }

    @Inject(method={"dispenseFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/dispenser/DispenseItemBehavior;dispense(Lnet/minecraft/core/BlockSource;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/core/dispenser/DispenseItemBehavior;NOOP:Lnet/minecraft/core/dispenser/DispenseItemBehavior;"), to=@At(value="TAIL"))}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void tracker$storeOriginalItem(ServerLevel worldIn, BlockPos pos, CallbackInfo ci, BlockSourceImpl source, DispenserBlockEntity dispenser, int slotIndex, ItemStack dispensedItem, DispenseItemBehavior behavior) {
        ItemStack tracker$originalItem = ItemStackUtil.cloneDefensiveNative(dispensedItem);
        this.tracker$originalItem = () -> tracker$originalItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dispenseFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/DispenserBlockEntity;setItem(ILnet/minecraft/world/item/ItemStack;)V"))
    private void tracker$setInventoryContentsCallEvent(DispenserBlockEntity dispenserTileEntity, int index, ItemStack stack) {
        ItemStack dispensedItem = ItemStack.EMPTY;
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(dispensedItem);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(dispenserTileEntity);
            DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.currentCause(), (List<ItemStackSnapshot>)ImmutableList.of((Object)snapshot), original);
            SpongeCommon.post(dropEvent);
            if (dropEvent.isCancelled()) {
                dispenserTileEntity.setItem(index, this.tracker$originalItem.get());
                return;
            }
            dispenserTileEntity.setItem(index, stack);
        }
        finally {
            this.tracker$originalItem = () -> ItemStack.EMPTY;
        }
    }
}

