/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import java.util.Collection;
import java.util.Objects;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.packet.HandlerPacketBinding;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketBinding;
import org.spongepowered.api.network.channel.packet.PacketHandler;
import org.spongepowered.common.network.channel.ConcurrentMultimap;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;

public final class SpongeHandlerPacketBinding<P extends Packet>
extends SpongePacketBinding<P>
implements HandlerPacketBinding<P> {
    private final ConcurrentMultimap<Class<?>, PacketHandler<? super P, ?>> handlers = new ConcurrentMultimap();

    SpongeHandlerPacketBinding(int opcode, Class<P> packetType) {
        super(opcode, packetType);
    }

    public <C extends EngineConnection> Collection<PacketHandler<? super P, ? super C>> getHandlers(C connection) {
        return SpongeChannel.getResponseHandlers(connection, this.handlers.get());
    }

    @Override
    public <C extends EngineConnection> PacketBinding<P> addHandler(EngineConnectionSide<C> side, PacketHandler<? super P, ? super C> handler) {
        Objects.requireNonNull(side, "side");
        return this.addHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public <C extends EngineConnection> PacketBinding<P> addHandler(Class<C> connectionType, PacketHandler<? super P, ? super C> handler) {
        Objects.requireNonNull(connectionType, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.put((Object)connectionType, (Object)handler));
        return this;
    }

    @Override
    public PacketBinding<P> addHandler(PacketHandler<? super P, EngineConnection> handler) {
        return this.addHandler(EngineConnection.class, handler);
    }

    @Override
    public <C extends EngineConnection> PacketBinding<P> removeHandler(EngineConnectionSide<C> side, PacketHandler<? super P, ? super C> handler) {
        Objects.requireNonNull(side, "side");
        return this.removeHandler(SpongeChannel.getConnectionClass(side), handler);
    }

    @Override
    public <C extends EngineConnection> PacketBinding<P> removeHandler(Class<C> connectionType, PacketHandler<? super P, ? super C> handler) {
        Objects.requireNonNull(connectionType, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> ((Class)entry.getKey()).isAssignableFrom(connectionType) && entry.getValue() == handler));
        return this;
    }

    @Override
    public PacketBinding<P> removeHandler(PacketHandler<? super P, ?> handler) {
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> entry.getValue() == handler));
        return this;
    }
}

