/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.server;

import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.util.locale.Locales;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.commands.CommandSourceBridge;
import org.spongepowered.common.bridge.commands.CommandSourceProviderBridge;
import org.spongepowered.common.service.server.permission.SpongeSystemSubject;

public final class ServerConsoleSystemSubject
extends SpongeSystemSubject
implements CommandSourceProviderBridge,
CommandSource,
CommandSourceBridge {
    @Override
    public String identifier() {
        return "console";
    }

    public void sendMessage(@NonNull Identity identity, @NonNull net.kyori.adventure.text.Component message, @NonNull MessageType type) {
        SpongeCommon.server().sendMessage(SpongeAdventure.asVanilla(message), identity.uuid());
    }

    @Override
    public CommandSourceStack bridge$getCommandSource(Cause cause) {
        return new CommandSourceStack((CommandSource)this, Vec3.ZERO, Vec2.ZERO, SpongeCommon.server().getLevel(Level.OVERWORLD), 4, "System Subject", (Component)new TextComponent("System Subject"), SpongeCommon.server(), null);
    }

    public void sendMessage(Component component, UUID identity) {
        SpongeCommon.logger().info(component.getString());
    }

    public boolean acceptsSuccess() {
        return true;
    }

    public boolean acceptsFailure() {
        return true;
    }

    public boolean shouldInformAdmins() {
        return true;
    }

    @Override
    public @NonNull Locale locale() {
        if (SpongeCommon.game().isClientAvailable()) {
            return SpongeCommon.game().client().locale();
        }
        return Locales.DEFAULT;
    }
}

