/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.MappedRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.accessor.world.entity.projectile.FireworkRocketEntityAccessor;
import org.spongepowered.common.item.SpongeFireworkEffectBuilder;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.util.NBTCollectors;
import org.spongepowered.common.util.NBTStreams;

public final class FireworkUtil {
    public static @Nullable FireworkEffect getStarEffect(ItemStack item) {
        Preconditions.checkArgument((item.getItem() == Items.FIREWORK_STAR ? 1 : 0) != 0, (Object)"Item is not a firework star!");
        @Nullable CompoundTag tag = item.getTagElement("Explosion");
        if (tag == null) {
            return null;
        }
        return FireworkUtil.fromCompound(tag);
    }

    public static FireworkEffect fromCompound(CompoundTag compound) {
        SpongeFireworkEffectBuilder builder = new SpongeFireworkEffectBuilder();
        if (compound.contains("Flicker")) {
            builder.flicker(compound.getBoolean("Flicker"));
        }
        if (compound.contains("Trail")) {
            builder.trail(compound.getBoolean("Trail"));
        }
        if (compound.contains("Type")) {
            byte type = compound.getByte("Type");
            MappedRegistry registry = (MappedRegistry)Sponge.game().registry(RegistryTypes.FIREWORK_SHAPE);
            @Nullable FireworkShape shape = (FireworkShape)registry.byId((int)type);
            if (shape != null) {
                builder.shape(shape);
            }
        }
        if (compound.contains("Colors")) {
            int[] colorsRaw;
            ArrayList colors = Lists.newArrayList();
            for (int color : colorsRaw = compound.getIntArray("Colors")) {
                colors.add(Color.ofRgb(color));
            }
            builder.colors((Iterable<Color>)colors);
        }
        if (compound.contains("FadeColors")) {
            int[] fadesRaw;
            ArrayList fades = Lists.newArrayList();
            for (int fade : fadesRaw = compound.getIntArray("FadeColors")) {
                fades.add(Color.ofRgb(fade));
            }
            builder.fades((Iterable<Color>)fades);
        }
        return builder.build();
    }

    public static CompoundTag toCompound(FireworkEffect effect) {
        MappedRegistry registry = (MappedRegistry)Sponge.game().registry(RegistryTypes.FIREWORK_SHAPE);
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Flicker", effect.flickers());
        tag.putBoolean("Trail", effect.hasTrail());
        tag.putByte("Type", (byte)registry.getId((Object)effect.shape()));
        int[] colorsArray = effect.colors().stream().mapToInt(Color::rgb).toArray();
        tag.putIntArray("Colors", colorsArray);
        int[] fadeArray = effect.fadeColors().stream().mapToInt(Color::rgb).toArray();
        tag.putIntArray("FadeColors", fadeArray);
        return tag;
    }

    public static boolean setFireworkEffects(Object object, List<? extends FireworkEffect> effects) {
        if (effects.isEmpty()) {
            return FireworkUtil.removeFireworkEffects(object);
        }
        ItemStack item = FireworkUtil.getItem(object);
        if (item.isEmpty()) {
            return false;
        }
        if (item.getItem() == Items.FIREWORK_STAR) {
            item.addTagElement("Explosion", (Tag)FireworkUtil.toCompound(effects.get(0)));
            return true;
        }
        if (item.getItem() == Items.FIREWORK_ROCKET) {
            CompoundTag fireworks = item.getOrCreateTagElement("Fireworks");
            fireworks.put("Explosions", (Tag)effects.stream().map(FireworkUtil::toCompound).collect(NBTCollectors.toTagList()));
            return true;
        }
        return false;
    }

    public static Optional<List<FireworkEffect>> getFireworkEffects(Object object) {
        Object effects;
        ItemStack item = FireworkUtil.getItem(object);
        if (item.isEmpty()) {
            return Optional.empty();
        }
        if (item.getItem() == Items.FIREWORK_ROCKET) {
            @Nullable CompoundTag fireworks = item.getTagElement("Fireworks");
            if (fireworks == null || !fireworks.contains("Explosions")) {
                return Optional.empty();
            }
            ListTag effectCompounds = fireworks.getList("Explosions", 10);
            effects = NBTStreams.toCompounds((Iterable<Tag>)effectCompounds).map(FireworkUtil::fromCompound).collect(Collectors.toList());
        } else {
            @Nullable FireworkEffect effect = FireworkUtil.getStarEffect(item);
            if (effect == null) {
                return Optional.empty();
            }
            effects = ImmutableList.of((Object)effect);
        }
        return Optional.of(effects);
    }

    public static boolean removeFireworkEffects(Object object) {
        ItemStack item = FireworkUtil.getItem(object);
        if (item.isEmpty()) {
            return false;
        }
        if (item.getItem() == Items.FIREWORK_STAR) {
            @Nullable CompoundTag tag = item.getTag();
            if (tag == null) {
                return true;
            }
            tag.remove("Explosion");
            return true;
        }
        if (item.getItem() == Items.FIREWORK_ROCKET) {
            CompoundTag fireworks = item.getOrCreateTagElement("Fireworks");
            fireworks.remove("Explosions");
            return true;
        }
        return false;
    }

    public static ItemStack getItem(FireworkRocketEntity firework) {
        ItemStack item = (ItemStack)firework.getEntityData().get(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM());
        if (item.isEmpty()) {
            item = (ItemStack)new SpongeItemStack.BuilderImpl().itemType(ItemTypes.FIREWORK_ROCKET).build();
            firework.getEntityData().set(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM(), (Object)item);
        }
        return item;
    }

    private static ItemStack getItem(Object object) {
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        if (object instanceof FireworkRocketEntity) {
            return FireworkUtil.getItem((FireworkRocketEntity)object);
        }
        return ItemStack.EMPTY;
    }

    private FireworkUtil() {
    }
}

