/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTCollectors {
    private static final Collector<Tag, ?, ListTag> TO_TAG_LIST = NBTCollectors.toTagList(value -> value);
    private static final Collector<Long, ?, ListTag> TO_LONG_TAG_LIST = NBTCollectors.toTagList(LongTag::valueOf);
    private static final Collector<Integer, ?, ListTag> TO_INT_TAG_LIST = NBTCollectors.toTagList(IntTag::valueOf);
    private static final Collector<Byte, ?, ListTag> TO_BYTE_TAG_LIST = NBTCollectors.toTagList(ByteTag::valueOf);
    private static final Collector<Short, ?, ListTag> TO_SHORT_TAG_LIST = NBTCollectors.toTagList(ShortTag::valueOf);
    private static final Collector<Boolean, ?, ListTag> TO_BOOLEAN_TAG_LIST = NBTCollectors.toTagList(ByteTag::valueOf);
    private static final Collector<Double, ?, ListTag> TO_DOUBLE_TAG_LIST = NBTCollectors.toTagList(DoubleTag::valueOf);
    private static final Collector<Float, ?, ListTag> TO_FLOAT_TAG_LIST = NBTCollectors.toTagList(FloatTag::valueOf);
    private static final Collector<String, ?, ListTag> TO_STRING_TAG_LIST = NBTCollectors.toTagList(StringTag::valueOf);
    private static final Collector<Tag, ?, List<String>> TO_STRING_LIST = NBTCollectors.toList(Tag::getAsString);

    private static <E> Collector<Tag, List<E>, List<E>> toList0(Function<Tag, E> toValueFunction) {
        return Collector.of(ArrayList::new, (list, value) -> list.add(toValueFunction.apply((Tag)value)), (first, second) -> {
            first.addAll(second);
            return first;
        }, list -> list, new Collector.Characteristics[0]);
    }

    public static <E> Collector<Tag, ?, List<E>> toList(Function<Tag, E> toValueFunction) {
        return NBTCollectors.toList0(toValueFunction);
    }

    public static <E> Collector<E, ?, ListTag> toTagList(Function<E, Tag> toTagFunction) {
        return Collector.of(ListTag::new, (list, value) -> list.add((Object)((Tag)toTagFunction.apply(value))), (first, second) -> {
            first.addAll((Collection)second);
            return first;
        }, list -> list, new Collector.Characteristics[0]);
    }

    public static Collector<Tag, ?, ListTag> toTagList() {
        return TO_TAG_LIST;
    }

    public static Collector<Boolean, ?, ListTag> toBooleanTagList() {
        return TO_BOOLEAN_TAG_LIST;
    }

    public static Collector<Byte, ?, ListTag> toByteTagList() {
        return TO_BYTE_TAG_LIST;
    }

    public static Collector<Short, ?, ListTag> toShortTagList() {
        return TO_SHORT_TAG_LIST;
    }

    public static Collector<Integer, ?, ListTag> toIntTagList() {
        return TO_INT_TAG_LIST;
    }

    public static Collector<Long, ?, ListTag> toLongTagList() {
        return TO_LONG_TAG_LIST;
    }

    public static Collector<Float, ?, ListTag> toFloatTagList() {
        return TO_FLOAT_TAG_LIST;
    }

    public static Collector<Double, ?, ListTag> toDoubleTagList() {
        return TO_DOUBLE_TAG_LIST;
    }

    public static Collector<String, ?, ListTag> toStringTagList() {
        return TO_STRING_TAG_LIST;
    }

    public static Collector<Tag, ?, List<String>> toStringList() {
        return TO_STRING_LIST;
    }

    private NBTCollectors() {
    }
}

