/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.transformers.modlauncher.AccessWidenerTransformationService;
import org.spongepowered.transformers.modlauncher.SuperclassChanger;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginPlatform;

public final class VanillaPlatformService
implements ITransformationService {
    private static final String NAME = "vanilla_platform";
    private static final VanillaPluginPlatform pluginPlatform = (VanillaPluginPlatform)AppLaunch.pluginPlatform();

    public @NonNull String name() {
        return NAME;
    }

    public void initialize(IEnvironment environment) {
        pluginPlatform.initialize();
    }

    public void beginScanning(IEnvironment environment) {
    }

    public List<Map.Entry<String, Path>> runScan(IEnvironment environment) {
        pluginPlatform.locatePluginResources();
        pluginPlatform.createPluginCandidates();
        AccessWidenerTransformationService accessWidener = environment.getProperty(AccessWidenerTransformationService.INSTANCE.get()).orElse(null);
        SuperclassChanger superclassChanger = environment.getProperty(SuperclassChanger.INSTANCE.get()).orElse(null);
        ILaunchPluginService mixin = environment.findLaunchPlugin("mixin").orElse(null);
        ArrayList<Map.Entry<String, Path>> launchResources = new ArrayList<Map.Entry<String, Path>>();
        for (Map.Entry<String, Set<PluginResource>> resourcesEntry : pluginPlatform.getResources().entrySet()) {
            Set<PluginResource> resources = resourcesEntry.getValue();
            for (PluginResource resource : resources) {
                if (accessWidener == null && mixin == null && superclassChanger == null || !(resource instanceof JVMPluginResource)) continue;
                if (mixin != null) {
                    mixin.offerResource(((JVMPluginResource)resource).path(), ((JVMPluginResource)resource).path().getFileName().toString());
                }
                ((JVMPluginResource)resource).manifest().ifPresent(manifest -> {
                    String superclassChangeFiles;
                    String atFiles;
                    if (accessWidener != null && (atFiles = manifest.getMainAttributes().getValue("Access-Widener")) != null) {
                        for (String atFile : atFiles.split(",")) {
                            if (!atFile.endsWith("accesswidener")) continue;
                            try {
                                accessWidener.offerResource(((JVMPluginResource)resource).fileSystem().getPath(atFile, new String[0]).toUri().toURL(), atFile);
                            }
                            catch (MalformedURLException ex) {
                                pluginPlatform.logger().warn("Failed to read declared access widener {}, from {}:", (Object)atFile, (Object)resource.locator());
                            }
                        }
                    }
                    if (mixin != null && manifest.getMainAttributes().getValue("MixinConfigs") != null && !VanillaPlatformService.isSponge((JVMPluginResource)resource)) {
                        pluginPlatform.logger().warn("Plugin from {} uses Mixins to modify the Minecraft Server. If something breaks, remove it before reporting the problem to Sponge!", (Object)((JVMPluginResource)resource).path());
                    }
                    if (superclassChanger != null && (superclassChangeFiles = manifest.getMainAttributes().getValue("Superclass-Transformer")) != null) {
                        for (String superclassChangeFile : superclassChangeFiles.split(",")) {
                            if (!superclassChangeFile.endsWith("superclasschange")) continue;
                            try {
                                superclassChanger.offerResource(((JVMPluginResource)resource).fileSystem().getPath(superclassChangeFile, new String[0]).toUri().toURL(), superclassChangeFile);
                            }
                            catch (MalformedURLException ex) {
                                pluginPlatform.logger().warn("Failed to read declared superclass changer {}, from {}:", (Object)superclassChangeFile, (Object)resource.locator());
                            }
                        }
                    }
                });
                Map.Entry entry = Maps.immutableEntry((Object)((JVMPluginResource)resource).path().getFileName().toString(), (Object)((JVMPluginResource)resource).path());
                launchResources.add(entry);
            }
        }
        return launchResources;
    }

    private static boolean isSponge(JVMPluginResource resource) {
        try {
            return resource.path().toUri().equals(VanillaPlatformService.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        VanillaPluginPlatform pluginPlatform = VanillaPlatformService.pluginPlatform;
        pluginPlatform.logger().info("SpongePowered PLUGIN Subsystem Version={} Source={}", (Object)pluginPlatform.version(), (Object)this.getCodeSource());
        pluginPlatform.discoverLocatorServices();
        pluginPlatform.getLocatorServices().forEach((k, v) -> pluginPlatform.logger().info("Plugin resource locator '{}' found.", k));
        pluginPlatform.discoverLanguageServices();
        pluginPlatform.getLanguageServices().forEach((k, v) -> pluginPlatform.logger().info("Plugin language loader '{}' found.", k));
    }

    public @NonNull List<ITransformer> transformers() {
        return ImmutableList.of();
    }

    private String getCodeSource() {
        try {
            return this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable th) {
            return "Unknown";
        }
    }
}

