/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.map.decoration;

import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.map.decoration.MapDecorationType;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.math.vector.Vector2i;

public interface MapDecoration
extends DataSerializable {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static MapDecoration of(MapDecorationType type, int x, int y, MapDecorationOrientation rotation) {
        return MapDecoration.builder().type(type).position(Vector2i.from((int)x, (int)y)).rotation(rotation).build();
    }

    public MapDecorationType type();

    public Vector2i position();

    public void setPosition(Vector2i var1);

    public void setRotation(MapDecorationOrientation var1);

    default public void setRotation(Supplier<MapDecorationOrientation> rotSupplier) {
        this.setRotation(rotSupplier.get());
    }

    public MapDecorationOrientation rotation();

    public boolean isPersistent();

    public static interface Builder
    extends ResettableBuilder<MapDecoration, Builder> {
        public Builder type(MapDecorationType var1);

        default public Builder type(Supplier<MapDecorationType> type) {
            return this.type(type.get());
        }

        public Builder rotation(MapDecorationOrientation var1);

        default public Builder rotation(Supplier<MapDecorationOrientation> rotSupplier) {
            return this.rotation(rotSupplier.get());
        }

        public Builder position(Vector2i var1) throws IllegalArgumentException;

        public Builder customName(Component var1);

        public Builder from(MapDecoration var1);

        public Builder fromContainer(DataView var1);

        public MapDecoration build() throws IllegalStateException;
    }
}

