/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;

public interface WorldManager {
    public Server server();

    public Optional<ServerWorld> world(ResourceKey var1);

    public Optional<Path> worldDirectory(ResourceKey var1);

    public Collection<ServerWorld> worlds();

    public List<ResourceKey> worldKeys();

    public List<ResourceKey> templateKeys();

    default public List<ResourceKey> offlineWorldKeys() {
        return this.worldKeys().stream().filter(v -> !this.world((ResourceKey)v).isPresent()).collect(Collectors.toList());
    }

    public boolean worldExists(ResourceKey var1);

    public Optional<ResourceKey> worldKey(UUID var1);

    public Collection<ServerWorld> worldsOfType(WorldType var1);

    public CompletableFuture<ServerWorld> loadWorld(WorldTemplate var1);

    public CompletableFuture<ServerWorld> loadWorld(ResourceKey var1);

    public CompletableFuture<Boolean> unloadWorld(ResourceKey var1);

    public CompletableFuture<Boolean> unloadWorld(ServerWorld var1);

    public boolean templateExists(ResourceKey var1);

    public CompletableFuture<Optional<WorldTemplate>> loadTemplate(ResourceKey var1);

    public CompletableFuture<Boolean> saveTemplate(WorldTemplate var1);

    public CompletableFuture<Optional<ServerWorldProperties>> loadProperties(ResourceKey var1);

    public CompletableFuture<Boolean> saveProperties(ServerWorldProperties var1);

    public CompletableFuture<Boolean> copyWorld(ResourceKey var1, ResourceKey var2);

    public CompletableFuture<Boolean> moveWorld(ResourceKey var1, ResourceKey var2);

    public CompletableFuture<Boolean> deleteWorld(ResourceKey var1);
}

