/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import java.util.Map;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.FrameType;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.SpongeCriterionUtil;

public final class SpongeAdvancementBuilder
extends AbstractResourceKeyedBuilder<Advancement, Advancement.Builder>
implements Advancement.Builder.RootStep {
    private @Nullable Advancement parent;
    private AdvancementCriterion criterion;
    private @Nullable DisplayInfo displayInfo;
    private @Nullable ResourceLocation backgroundPath;

    public SpongeAdvancementBuilder() {
        this.reset();
    }

    @Override
    public Advancement.Builder parent(@Nullable Advancement parent) {
        this.parent = parent;
        this.backgroundPath = null;
        return this;
    }

    @Override
    public Advancement.Builder.RootStep root() {
        this.parent = null;
        return this;
    }

    @Override
    public Advancement.Builder background(ResourceKey backgroundPath) {
        this.backgroundPath = (ResourceLocation)backgroundPath;
        return this;
    }

    @Override
    public Advancement.Builder criterion(AdvancementCriterion criterion) {
        Preconditions.checkNotNull((Object)criterion, (Object)"criterion");
        this.criterion = criterion;
        return this;
    }

    @Override
    public Advancement.Builder displayInfo(@Nullable DisplayInfo displayInfo) {
        this.displayInfo = displayInfo;
        return this;
    }

    @Override
    public Advancement.Builder reset() {
        this.criterion = AdvancementCriterion.empty();
        this.displayInfo = null;
        this.parent = null;
        this.backgroundPath = null;
        return this;
    }

    @Override
    public Advancement build0() {
        Tuple<Map<String, Criterion>, String[][]> result = SpongeCriterionUtil.toVanillaCriteriaData(this.criterion);
        AdvancementRewards rewards = AdvancementRewards.EMPTY;
        ResourceLocation resourceLocation = (ResourceLocation)this.key;
        net.minecraft.advancements.DisplayInfo displayInfo = this.displayInfo == null ? null : new net.minecraft.advancements.DisplayInfo(ItemStackUtil.fromSnapshotToNative(this.displayInfo.icon()), SpongeAdventure.asVanilla(this.displayInfo.title()), SpongeAdventure.asVanilla(this.displayInfo.description()), this.backgroundPath, (FrameType)this.displayInfo.type(), this.displayInfo.doesShowToast(), this.displayInfo.doesAnnounceToChat(), this.displayInfo.isHidden());
        net.minecraft.advancements.Advancement parent = (net.minecraft.advancements.Advancement)this.parent;
        Advancement advancement = (Advancement)new net.minecraft.advancements.Advancement(resourceLocation, parent, displayInfo, rewards, result.first(), result.second());
        ((AdvancementBridge)((Object)advancement)).bridge$setCriterion(this.criterion);
        return advancement;
    }
}

