/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.bridge.adventure.ComponentBridge;
import org.spongepowered.common.bridge.network.chat.BaseComponentBridge;
import org.spongepowered.common.util.LocaleCache;

public class AdventureTextComponent
implements Component,
BaseComponentBridge {
    private @MonotonicNonNull Component converted;
    private @Nullable Locale deepConvertedLocalized;
    private final net.kyori.adventure.text.Component wrapped;
    private final @Nullable ComponentRenderer<Locale> renderer;
    private @Nullable Locale lastLocale;
    private @Nullable AdventureTextComponent lastRendered;

    public AdventureTextComponent(net.kyori.adventure.text.Component wrapped, @Nullable ComponentRenderer<Locale> renderer) {
        this.wrapped = wrapped;
        this.renderer = renderer;
    }

    public @Nullable ComponentRenderer<Locale> renderer() {
        return this.renderer;
    }

    public net.kyori.adventure.text.Component wrapped() {
        return this.wrapped;
    }

    public synchronized AdventureTextComponent rendered(Locale locale) {
        if (Objects.equals(locale, this.lastLocale)) {
            return this.lastRendered;
        }
        this.lastLocale = locale;
        this.lastRendered = this.renderer == null ? this : new AdventureTextComponent(this.renderer.render(this.wrapped, (Object)locale), null);
        return this.lastRendered;
    }

    Component deepConverted() {
        Component converted = this.converted;
        if (converted == null || this.deepConvertedLocalized != null) {
            converted = this.converted = ((ComponentBridge)this.wrapped).bridge$asVanillaComponent();
            this.deepConvertedLocalized = null;
        }
        return converted;
    }

    @OnlyIn(value=Dist.CLIENT)
    Component deepConvertedLocalized() {
        Component converted = this.converted;
        Locale target = LocaleCache.getLocale(Minecraft.getInstance().options.languageCode);
        if (converted == null || this.deepConvertedLocalized != target) {
            converted = this.converted = this.rendered(target).deepConverted();
            this.deepConvertedLocalized = target;
        }
        return converted;
    }

    public @Nullable Component deepConvertedIfPresent() {
        return this.converted;
    }

    public Style getStyle() {
        return this.deepConverted().getStyle();
    }

    public String getString() {
        return this.rendered(Locale.getDefault()).deepConverted().getString();
    }

    public String getString(int length) {
        return this.deepConverted().getString(length);
    }

    public String getContents() {
        if (this.wrapped instanceof TextComponent) {
            return ((TextComponent)this.wrapped).content();
        }
        return this.deepConverted().getContents();
    }

    public List<Component> getSiblings() {
        return this.deepConverted().getSiblings();
    }

    public MutableComponent plainCopy() {
        return this.deepConverted().plainCopy();
    }

    public MutableComponent copy() {
        return this.deepConverted().copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public FormattedCharSequence getVisualOrderText() {
        return this.deepConvertedLocalized().getVisualOrderText();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> visitor, Style style) {
        return this.deepConvertedLocalized().visit(visitor, style);
    }

    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> visitor) {
        return this.deepConverted().visit(visitor);
    }

    @Override
    public net.kyori.adventure.text.Component bridge$asAdventureComponent() {
        return this.wrapped;
    }

    @Override
    public @Nullable net.kyori.adventure.text.Component bridge$adventureComponentIfPresent() {
        return this.bridge$asAdventureComponent();
    }
}

