/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.command.parameter.managed.standard.SpongeCatalogedElementValueParameter;

public final class SpongeRegistryEntryParameterBuilder<T>
implements VariableValueParameters.RegistryEntryBuilder<T> {
    private final List<Function<CommandContext, @Nullable RegistryHolder>> registryFunctions = new ArrayList<Function<CommandContext, RegistryHolder>>();
    private final RegistryType<? extends T> registryType;
    private final List<String> prefixes = new ArrayList<String>();

    public SpongeRegistryEntryParameterBuilder(RegistryType<? extends T> registryType) {
        this.registryType = registryType;
    }

    @Override
    public  @NonNull VariableValueParameters.RegistryEntryBuilder<T> addHolderFunction(@NonNull Function<CommandContext, @Nullable RegistryHolder> holderFunction) {
        this.registryFunctions.add(holderFunction);
        return this;
    }

    @Override
    public  @NonNull VariableValueParameters.RegistryEntryBuilder<T> defaultNamespace(@NonNull String prefix) {
        this.prefixes.add(Objects.requireNonNull(prefix, "Prefix cannot be null!"));
        return this;
    }

    @Override
    public @NonNull ValueParameter<T> build() {
        if (this.registryFunctions.isEmpty()) {
            throw new IllegalStateException("No RegistryHolder functions were supplied.");
        }
        return new SpongeCatalogedElementValueParameter<T>(new ArrayList<String>(this.prefixes), new ArrayList<Function<CommandContext, RegistryHolder>>(this.registryFunctions), this.registryType);
    }

    @Override
    public  @NonNull VariableValueParameters.RegistryEntryBuilder<T> reset() {
        this.prefixes.clear();
        return this;
    }
}

