/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.customdata;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.persistence.SerializedDataTransaction;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStore;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class CustomDataRegistrationCategory {
    @Setting(value="registered-data")
    @Comment(value="An auto generated list, by Sponge, to provide a list of \nregistered custom data manipulators by plugins. Since \nthe list is generated AFTER the game starts, modifying \nthis list will not affect Sponge's system in any way. \nHowever, it is advisable to view what registered datas \nexist on a server instance, such that when Sponge completes \nstartup, it will be verified that all existing registrations \nare accounted for. A warning will be emitted for any existing \nregistrations that were not registered, and moved to the \n'failed-data-list'.")
    public final Set<String> registeredData = new ConcurrentSkipListSet<String>();
    @Setting(value="failed-data")
    @Comment(value="An auto generated list, by Sponge, to discover and list \nall failed custom data deserializations at runtime due \nto a lack of the registrations being made by a plugin. \nNot to be confused by failed deserialization due to bad data. \nModifying the list will result in no effect as Sponge auto \ngenerates this list. This is merely for user configuration.")
    public final Set<String> failedData = new ConcurrentSkipListSet<String>();
    @Setting(value="data-to-purge")
    @Comment(value="A configurable list of registration ids that are to be removed \nwhen discovered for deserialization. This can be controlled by \ncommands in sponge. It is adviseable to refer to the lists made \navailable through 'failed-data-list', as using any id's from \n'registered-data' will result in custom data being deleted at \nevery load.")
    public final Set<String> dataToPurge = new ConcurrentSkipListSet<String>();
    @Setting(value="print-failed-data")
    @Comment(value="In the cases where there is already previously discovered data \nwe don't want to spam the log on each discovery in certain \ncontexts. If it is required, we still can emit the log warning \nwhen necessary.")
    public boolean printFailedData = false;

    public void populateRegistrations(Collection<SpongeDataStore> stores) {
        this.registeredData.clear();
        for (SpongeDataStore store : stores) {
            this.registeredData.add(store.getDataStoreKey().formatted());
        }
    }

    public void addFailedData(String dataId, Throwable cause) {
        if (this.failedData.add(dataId) && this.printFailedData) {
            new PrettyPrinter(60).add("Failed Data Discovery").centre().hr().addWrapped("Sponge found an unregistered DataRegistration id. Don't worry though!Sponge will attempt to persist the failed data for future attempts, unlessthe id is added in 'data-to-purge' in the sponge/custom-data.cnf", new Object[0]).add().add("%s : %s", "Unregistered Id", dataId).add(new InvalidDataException("Could not deserialize " + dataId + "!", cause)).trace();
        }
    }

    public void purgeOrAllow(SerializedDataTransaction.Builder builder, String data, DataView view) {
        if (!this.dataToPurge.contains(data)) {
            builder.failedData(view);
        }
    }
}

