/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.item.ItemRarity;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.NestedTableEntry;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.accessor.world.item.DiggerItemAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class ItemStackData {
    private ItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.APPLICABLE_POTION_EFFECTS).get(h -> {
            if (h.isEdible()) {
                List itemEffects = h.getItem().getFoodProperties().getEffects();
                WeightedTable effects = new WeightedTable();
                ChanceTable<PotionEffect> chance = new ChanceTable<PotionEffect>();
                for (Pair effect : itemEffects) {
                    chance.add((PotionEffect)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
                }
                effects.add(new NestedTableEntry(1.0, chance));
                return effects;
            }
            return null;
        })).create(Keys.BURN_TIME).get(h -> {
            Integer burnTime = (Integer)AbstractFurnaceBlockEntity.getFuel().get(h.getItem());
            if (burnTime != null && burnTime > 0) {
                return burnTime;
            }
            return null;
        })).create(Keys.CAN_HARVEST).get(h -> {
            Item item = h.getItem();
            if (item instanceof DiggerItemAccessor && !(item instanceof PickaxeItem)) {
                return Registry.BLOCK.getTag(((DiggerItemAccessor)item).accessor$blocks()).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).map(BlockType.class::cast).collect(Collectors.toSet());
            }
            Set blockTypes = Registry.BLOCK.stream().filter(b -> item.isCorrectToolForDrops(b.defaultBlockState())).map(BlockType.class::cast).collect(Collectors.toUnmodifiableSet());
            return blockTypes.isEmpty() ? null : blockTypes;
        })).create(Keys.CONTAINER_ITEM).get(h -> (ItemType)h.getItem().getCraftingRemainingItem())).create(Keys.DISPLAY_NAME).get(h -> SpongeAdventure.asAdventure(h.getDisplayName()))).create(Keys.CUSTOM_MODEL_DATA).get(h -> {
            CompoundTag tag = h.getTag();
            if (tag == null || !tag.contains("CustomModelData", 3)) {
                return null;
            }
            return tag.getInt("CustomModelData");
        })).set((h, v) -> {
            CompoundTag tag = h.getOrCreateTag();
            tag.putInt("CustomModelData", v.intValue());
        })).delete(h -> {
            CompoundTag tag = h.getTag();
            if (tag != null) {
                tag.remove("CustomModelData");
            }
        })).create(Keys.CUSTOM_NAME).get(h -> {
            CompoundTag tag;
            if (h.hasCustomHoverName()) {
                return SpongeAdventure.asAdventure(h.getHoverName());
            }
            if (h.getItem() == Items.WRITTEN_BOOK && (tag = h.getTag()) != null) {
                String title = tag.getString("title");
                return LegacyComponentSerializer.legacySection().deserialize(title);
            }
            return null;
        })).set((h, v) -> h.setHoverName(SpongeAdventure.asVanilla(v)))).delete(ItemStack::resetHoverName)).create(Keys.IS_UNBREAKABLE).get(h -> {
            CompoundTag tag = h.getTag();
            if (tag == null || !tag.contains("Unbreakable", 1)) {
                return false;
            }
            return tag.getBoolean("Unbreakable");
        })).set(ItemStackData::setIsUnbrekable)).delete(h -> ItemStackData.setIsUnbrekable(h, false))).create(Keys.LORE).get(h -> {
            CompoundTag tag = h.getTag();
            if (tag == null || !tag.contains("display")) {
                return null;
            }
            CompoundTag displayCompound = tag.getCompound("display");
            ListTag list = displayCompound.getList("Lore", 8);
            return list.isEmpty() ? null : SpongeAdventure.json(list.stream().collect(NBTCollectors.toStringList()));
        })).set((h, v) -> {
            if (v.isEmpty()) {
                ItemStackData.deleteLore(h);
                return;
            }
            ListTag list = SpongeAdventure.listTagJson(v);
            h.getOrCreateTagElement("display").put("Lore", (Tag)list);
        })).delete(ItemStackData::deleteLore)).create(Keys.MAX_DURABILITY).get(h -> h.getItem().canBeDepleted() ? Integer.valueOf(h.getItem().getMaxDamage()) : null)).supports(h -> h.getItem().canBeDepleted())).create(Keys.ITEM_DURABILITY).get(stack -> stack.getMaxDamage() - stack.getDamageValue())).set((stack, durability) -> stack.setDamageValue(stack.getMaxDamage() - durability))).supports(h -> h.getItem().canBeDepleted())).create(Keys.ITEM_RARITY).get(stack -> (ItemRarity)stack.getRarity())).create(Keys.REPLENISHED_FOOD).get(h -> {
            if (h.getItem().isEdible()) {
                FoodProperties food = h.getItem().getFoodProperties();
                return food == null ? null : Integer.valueOf(food.getNutrition());
            }
            return null;
        })).supports(h -> h.getItem().isEdible())).create(Keys.REPLENISHED_SATURATION).get(h -> {
            FoodProperties food;
            if (h.getItem().isEdible() && (food = h.getItem().getFoodProperties()) != null) {
                return (double)(food.getSaturationModifier() * (float)food.getNutrition()) * 2.0;
            }
            return null;
        })).supports(h -> h.getItem().isEdible());
    }

    private static void setIsUnbrekable(ItemStack stack, Boolean value) {
        if (value == null || !value.booleanValue() && !stack.hasTag()) {
            return;
        }
        CompoundTag tag = stack.getOrCreateTag();
        if (value.booleanValue()) {
            tag.putBoolean("Unbreakable", true);
        } else {
            tag.remove("Unbreakable");
        }
    }

    private static void deleteLore(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag != null && tag.contains("display")) {
            tag.getCompound("display").remove("Lore");
        }
    }
}

