/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPackType;
import org.spongepowered.common.datapack.tag.TagSerializedObject;

public final class TagDataPackSerializer
extends DataPackSerializer<TagSerializedObject> {
    public TagDataPackSerializer(String token, String typeDirectoryName) {
        super(token, typeDirectoryName);
    }

    private String tagTypeName(RegistryType<?> registryType) {
        return Holder.REGISTRY_TYPES_TO_DIRECTORY.getOrDefault(registryType.location().asString(), ((ResourceLocation)registryType.location()).toDebugFileName());
    }

    @Override
    protected boolean serialize(SpongeDataPackType<@NonNull ?, TagSerializedObject> type, Path datapacksDir, List<TagSerializedObject> objects, int count) throws IOException {
        Path datapackDir = datapacksDir.resolve(this.getPackName());
        if (!type.persistent()) {
            FileUtils.deleteDirectory((File)datapackDir.toFile());
        }
        if (objects.isEmpty()) {
            return false;
        }
        for (TagSerializedObject object : objects) {
            Path namespacedDataDirectory = datapackDir.resolve("data").resolve(object.getKey().namespace());
            String filename = object.getKey().value() + ".json";
            Path objectFile = namespacedDataDirectory.resolve(this.typeDirectoryName).resolve(this.tagTypeName(object.getRegistryType())).resolve(filename);
            Files.createDirectories(objectFile.getParent(), new FileAttribute[0]);
            JsonObject toWrite = object.getObject();
            if (Files.exists(objectFile, new LinkOption[0]) && !object.getObject().getAsJsonPrimitive("replace").getAsBoolean()) {
                JsonObject jsonObject;
                try (BufferedReader bufferedReader = Files.newBufferedReader(objectFile);){
                    JsonElement jsonElement = JsonParser.parseReader(bufferedReader);
                    jsonObject = jsonElement.getAsJsonObject();
                }
                toWrite = Tag.Builder.tag().addFromJson(jsonObject, filename).addFromJson(object.getObject(), filename).serializeToJson();
            }
            DataPackSerializer.writeFile(objectFile, toWrite);
            this.serializeAdditional(namespacedDataDirectory, object);
        }
        DataPackSerializer.writePackMetadata(this.name, datapackDir);
        return true;
    }

    private static final class Holder {
        static final Map<String, String> REGISTRY_TYPES_TO_DIRECTORY = Map.ofEntries(Map.entry(Registry.BLOCK_REGISTRY.location().getPath(), "blocks"), Map.entry(Registry.ENTITY_TYPE_REGISTRY.location().getPath(), "entity_types"), Map.entry(Registry.FLUID_REGISTRY.location().getPath(), "fluids"), Map.entry(Registry.GAME_EVENT_REGISTRY.location().getPath(), "game_events"), Map.entry(Registry.ITEM_REGISTRY.location().getPath(), "items"));

        private Holder() {
        }
    }
}

