/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.golem.Shulker;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;
import org.spongepowered.common.entity.projectile.ProjectileUtil;

public final class ShulkerSourceLogic
implements ProjectileSourceLogic<Shulker> {
    @Override
    public <P extends Projectile> Optional<P> launch(ProjectileLogic<P> logic, Shulker source, EntityType<P> projectileType, Object ... args) {
        if (projectileType == EntityTypes.SHULKER_BULLET.get() && args.length == 1 && args[0] instanceof Entity) {
            net.minecraft.world.entity.monster.Shulker shulker = (net.minecraft.world.entity.monster.Shulker)source;
            ShulkerBullet bullet = new ShulkerBullet(shulker.level, (LivingEntity)shulker, (Entity)args[0], shulker.getAttachFace().getAxis());
            shulker.level.addFreshEntity((Entity)bullet);
            shulker.playSound(SoundEvents.SHULKER_SHOOT, 2.0f, (shulker.level.random.nextFloat() - shulker.level.random.nextFloat()) * 0.2f + 1.0f);
            return Optional.of((Projectile)bullet);
        }
        return ProjectileUtil.launch(projectileType, source, null);
    }
}

