/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.filter;

import io.leangen.geantyref.AnnotationFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.filter.cause.After;
import org.spongepowered.api.event.filter.cause.All;
import org.spongepowered.api.event.filter.cause.Before;
import org.spongepowered.api.event.filter.cause.ContextValue;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.cause.Last;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.filter.data.GetValue;
import org.spongepowered.api.event.filter.data.Has;
import org.spongepowered.api.event.filter.data.Supports;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.filter.type.Include;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.delegate.AfterCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.AllCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.BeforeCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.CancellationEventFilterDelegate;
import org.spongepowered.common.event.filter.delegate.ContextValueFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.ExcludeSubtypeFilterDelegate;
import org.spongepowered.common.event.filter.delegate.FilterDelegate;
import org.spongepowered.common.event.filter.delegate.FirstCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.GetValueFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.GetterFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.HasDataFilterDelegate;
import org.spongepowered.common.event.filter.delegate.IncludeSubtypeFilterDelegate;
import org.spongepowered.common.event.filter.delegate.LastCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.ParameterFilterDelegate;
import org.spongepowered.common.event.filter.delegate.ParameterFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.RootCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.SubtypeFilterDelegate;
import org.spongepowered.common.event.filter.delegate.SupportsDataFilterDelegate;
import org.spongepowered.common.event.gen.LoaderClassWriter;
import org.spongepowered.common.event.manager.ListenerClassVisitor;
import org.spongepowered.common.util.generator.GeneratorUtils;

public class FilterGenerator {
    public static final boolean FILTER_DEBUG = Boolean.parseBoolean(System.getProperty("sponge.filter.debug", "false"));
    public static final String FILTER_DESCRIPTOR = "(" + Type.getDescriptor(Event.class) + ")[Ljava/lang/Object;";
    private static final Logger LOGGER = LogManager.getLogger();

    public static FilterGenerator getInstance() {
        return Holder.INSTANCE;
    }

    FilterGenerator() {
    }

    public static @Nullable EventFilter create(ListenerClassVisitor.DiscoveredMethod method, MethodHandles.Lookup lookup) throws IllegalAccessException, ClassNotFoundException {
        if (!lookup.hasFullPrivilegeAccess()) {
            throw new IllegalArgumentException("The provided lookup '" + lookup + "' does not have full privilege access required to create a hidden class");
        }
        Class<?> handle = method.declaringClass();
        String name = "Filter_" + method.methodName();
        byte[] cls = FilterGenerator.getInstance().generateClass(handle, name, method);
        if (cls == null) {
            return null;
        }
        MethodHandles.Lookup filter = lookup.defineHiddenClass(cls, true, MethodHandles.Lookup.ClassOption.NESTMATE);
        try {
            return filter.findConstructor(filter.lookupClass(), MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Generated filter class did not have expected empty constructor!", ex);
        }
    }

    public byte[] generateClass(Class<?> handle, String localName, ListenerClassVisitor.DiscoveredMethod method) throws ClassNotFoundException {
        int i;
        String name = Type.getInternalName(handle) + "_" + localName;
        ListenerClassVisitor.ListenerParameter[] parameters = method.parameterTypes();
        SubtypeFilterDelegate sfilter = null;
        ArrayList<FilterDelegate> additional = new ArrayList<FilterDelegate>();
        boolean cancellation = false;
        for (ListenerClassVisitor.ListenerAnnotation anno : method.annotations()) {
            Annotation annotation;
            try {
                annotation = anno.annotation();
            }
            catch (AnnotationFormatException e) {
                throw new ClassNotFoundException("Failed to load annotation", e);
            }
            Iterator obj = FilterGenerator.filterFromAnnotation(method, anno);
            if (obj == null) continue;
            if (obj instanceof SubtypeFilter) {
                if (sfilter != null) {
                    throw new IllegalStateException("Cannot have both @Include and @Exclude annotations present at once");
                }
                sfilter = ((SubtypeFilter)((Object)obj)).getDelegate(annotation);
                continue;
            }
            if (!(obj instanceof EventTypeFilter)) continue;
            EventTypeFilter etf = (EventTypeFilter)((Object)obj);
            additional.add(etf.getDelegate(annotation));
            if (etf != EventTypeFilter.CANCELLATION) continue;
            cancellation = true;
        }
        if (!cancellation) {
            additional.add(new CancellationEventFilterDelegate(Tristate.FALSE));
        }
        if (additional.isEmpty() && sfilter == null && parameters.length == 1) {
            return null;
        }
        LoaderClassWriter cw = new LoaderClassWriter(method.declaringClass().getClassLoader(), 3);
        cw.visit(55, 49, name, null, "java/lang/Object", new String[]{Type.getInternalName(EventFilter.class)});
        if (sfilter != null) {
            sfilter.createFields(cw);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        if (sfilter != null) {
            sfilter.writeCtor(name, cw, mv);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "filter", FILTER_DESCRIPTOR, null, null);
        mv.visitCode();
        int local = 2;
        if (sfilter != null) {
            local = sfilter.write(name, cw, mv, method, local);
        }
        for (FilterDelegate eventFilter : additional) {
            local = eventFilter.write(name, cw, mv, method, local);
        }
        int[] plocals = new int[parameters.length - 1];
        for (i = 1; i < parameters.length; ++i) {
            ListenerClassVisitor.ListenerParameter param = parameters[i];
            ParameterFilterSourceDelegate source = null;
            ArrayList<ParameterFilterDelegate> paramFilters = new ArrayList<ParameterFilterDelegate>();
            for (ListenerClassVisitor.ListenerAnnotation anno : param.annotations()) {
                Annotation annotation;
                Object obj = FilterGenerator.filterFromAnnotation(method, anno);
                if (obj == null) continue;
                try {
                    annotation = anno.annotation();
                }
                catch (AnnotationFormatException e) {
                    throw new ClassNotFoundException("Failed to load annotation", e);
                }
                if (obj instanceof ParameterSource) {
                    if (source != null) {
                        throw new IllegalStateException("Cannot have multiple parameter filter source annotations (for " + param.name() + ")");
                    }
                    source = ((ParameterSource)((Object)obj)).getDelegate(annotation);
                    continue;
                }
                if (!(obj instanceof ParameterFilter)) continue;
                paramFilters.add(((ParameterFilter)((Object)obj)).getDelegate(annotation));
            }
            if (source == null) {
                throw new IllegalStateException("Cannot have additional parameters filters without a source (for " + param.name() + ")");
            }
            if (source instanceof AllCauseFilterSourceDelegate && !paramFilters.isEmpty()) {
                throw new IllegalStateException("Cannot have additional parameters filters without an array source (for " + param.name() + ")");
            }
            Tuple<Integer, Integer> localState = source.write(cw, mv, method, i, local, plocals, parameters);
            local = localState.first();
            plocals[i - 1] = localState.second();
            for (ParameterFilterDelegate paramFilter : paramFilters) {
                paramFilter.write(cw, mv, param, plocals[i - 1]);
            }
        }
        if (parameters.length == 1) {
            mv.visitInsn(4);
        } else {
            mv.visitIntInsn(16, parameters.length);
        }
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(83);
        for (i = 1; i < parameters.length; ++i) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            Type paramType = parameters[i].type();
            mv.visitVarInsn(paramType.getOpcode(21), plocals[i - 1]);
            GeneratorUtils.visitBoxingMethod(mv, paramType);
            mv.visitInsn(83);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] data = cw.toByteArray();
        if (FILTER_DEBUG) {
            File outDir = new File(".sponge.debug.out");
            File outFile = new File(outDir, name + ".class");
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            try (FileOutputStream out = new FileOutputStream(outFile);){
                out.write(data);
            }
            catch (IOException e) {
                LOGGER.error("Failed to write class to debug directory", (Throwable)e);
            }
        }
        return data;
    }

    private static @Nullable Object filterFromAnnotation(ListenerClassVisitor.DiscoveredMethod method, ListenerClassVisitor.ListenerAnnotation anno) {
        Optional<Class<?>> clazz = method.optionalClassByLoader(anno.type().getClassName());
        return clazz.map(cls -> {
            Enum filter = SubtypeFilter.valueOf(cls);
            if (filter != null) {
                return filter;
            }
            filter = EventTypeFilter.valueOf(cls);
            if (filter != null) {
                return filter;
            }
            filter = ParameterSource.valueOf(cls);
            if (filter != null) {
                return filter;
            }
            filter = ParameterFilter.valueOf(cls);
            if (filter != null) {
                return filter;
            }
            return null;
        }).orElse(null);
    }

    private static final class Holder {
        static final FilterGenerator INSTANCE = new FilterGenerator();

        private Holder() {
        }
    }

    private static enum SubtypeFilter {
        INCLUDE(Include.class, IncludeSubtypeFilterDelegate::new),
        EXCLUDE(Exclude.class, ExcludeSubtypeFilterDelegate::new);

        private static final Map<Class<? extends Annotation>, SubtypeFilter> BY_CLAZZ;
        private final Class<? extends Annotation> cls;
        private final Function<Annotation, SubtypeFilterDelegate> factory;

        private <T extends Annotation> SubtypeFilter(Class<? extends Annotation> cls, Function<T, SubtypeFilterDelegate> factory) {
            this.cls = cls;
            this.factory = factory;
        }

        public SubtypeFilterDelegate getDelegate(Annotation anno) {
            return this.factory.apply(anno);
        }

        public static SubtypeFilter valueOf(Class<?> cls) {
            return BY_CLAZZ.get(cls);
        }

        static {
            HashMap<Class<? extends Annotation>, SubtypeFilter> byClazz = new HashMap<Class<? extends Annotation>, SubtypeFilter>();
            for (SubtypeFilter value : SubtypeFilter.values()) {
                byClazz.put(value.cls, value);
            }
            BY_CLAZZ = Collections.unmodifiableMap(byClazz);
        }
    }

    private static enum EventTypeFilter {
        CANCELLATION(IsCancelled.class, CancellationEventFilterDelegate::new);

        private static final Map<Class<? extends Annotation>, EventTypeFilter> BY_CLAZZ;
        private final Class<? extends Annotation> cls;
        private final Function<Annotation, FilterDelegate> factory;

        private <T extends Annotation> EventTypeFilter(Class<T> cls, Function<T, FilterDelegate> factory) {
            this.cls = cls;
            this.factory = factory;
        }

        public FilterDelegate getDelegate(Annotation anno) {
            return this.factory.apply(anno);
        }

        public static EventTypeFilter valueOf(Class<?> cls) {
            return BY_CLAZZ.get(cls);
        }

        static {
            HashMap<Class<? extends Annotation>, EventTypeFilter> byClazz = new HashMap<Class<? extends Annotation>, EventTypeFilter>();
            for (EventTypeFilter value : EventTypeFilter.values()) {
                byClazz.put(value.cls, value);
            }
            BY_CLAZZ = Collections.unmodifiableMap(byClazz);
        }
    }

    private static enum ParameterSource {
        CAUSE_FIRST(First.class, FirstCauseFilterSourceDelegate::new),
        CAUSE_LAST(Last.class, LastCauseFilterSourceDelegate::new),
        CAUSE_BEFORE(Before.class, BeforeCauseFilterSourceDelegate::new),
        CAUSE_AFTER(After.class, AfterCauseFilterSourceDelegate::new),
        CAUSE_ALL(All.class, AllCauseFilterSourceDelegate::new),
        CAUSE_ROOT(Root.class, RootCauseFilterSourceDelegate::new),
        GETTER(Getter.class, GetterFilterSourceDelegate::new),
        GET_VALUE(GetValue.class, GetValueFilterSourceDelegate::new),
        CONTEXT_VALUE(ContextValue.class, ContextValueFilterSourceDelegate::new);

        private static final Map<Class<? extends Annotation>, ParameterSource> BY_CLAZZ;
        private final Class<? extends Annotation> cls;
        private final Function<Annotation, ParameterFilterSourceDelegate> factory;

        private <T extends Annotation> ParameterSource(Class<T> cls, Function<T, ParameterFilterSourceDelegate> factory) {
            this.cls = cls;
            this.factory = factory;
        }

        public ParameterFilterSourceDelegate getDelegate(Annotation anno) {
            return this.factory.apply(anno);
        }

        public static ParameterSource valueOf(Class<?> cls) {
            return BY_CLAZZ.get(cls);
        }

        static {
            HashMap<Class<? extends Annotation>, ParameterSource> byClazz = new HashMap<Class<? extends Annotation>, ParameterSource>();
            for (ParameterSource value : ParameterSource.values()) {
                byClazz.put(value.cls, value);
            }
            BY_CLAZZ = Collections.unmodifiableMap(byClazz);
        }
    }

    private static enum ParameterFilter {
        SUPPORTS(Supports.class, SupportsDataFilterDelegate::new),
        HAS(Has.class, HasDataFilterDelegate::new);

        private static final Map<Class<? extends Annotation>, ParameterFilter> BY_CLAZZ;
        private final Class<? extends Annotation> cls;
        private final Function<Annotation, ParameterFilterDelegate> factory;

        private <T extends Annotation> ParameterFilter(Class<T> cls, Function<T, ParameterFilterDelegate> factory) {
            this.cls = cls;
            this.factory = factory;
        }

        public ParameterFilterDelegate getDelegate(Annotation anno) {
            return this.factory.apply(anno);
        }

        public static ParameterFilter valueOf(Class<?> cls) {
            return BY_CLAZZ.get(cls);
        }

        static {
            HashMap<Class<? extends Annotation>, ParameterFilter> byClazz = new HashMap<Class<? extends Annotation>, ParameterFilter>();
            for (ParameterFilter value : ParameterFilter.values()) {
                byClazz.put(value.cls, value);
            }
            BY_CLAZZ = Collections.unmodifiableMap(byClazz);
        }
    }
}

