/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.ticks.ScheduledTick;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;

public abstract class PacketState<P extends PacketContext<P>>
extends PooledPhaseState<P>
implements IPhaseState<P> {
    private final BiConsumer<CauseStackManager.StackFrame, P> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.packetPlayer != null) {
            frame.pushCause(ctx.packetPlayer);
        }
    });
    private final String desc = TrackingUtil.phaseStateToString("Packet", this);

    protected PacketState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, P> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public void unwind(P phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    public boolean matches(int packetState) {
        return false;
    }

    @Override
    public void associateNeighborStateNotifier(P unwindingContext, BlockPos sourcePos, Block block, BlockPos notifyPos, ServerLevel minecraftWorld, PlayerTracker.Type notifier) {
        ServerPlayer player = ((PacketContext)unwindingContext).getSpongePlayer();
        LevelChunk chunk = minecraftWorld.getChunkAt(notifyPos);
        ((LevelChunkBridge)chunk).bridge$setBlockNotifier(notifyPos, player.uniqueId());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(P context, Entity entityToSpawn) {
        return SpawnTypes.PLACEMENT;
    }

    @Override
    public void associateScheduledTickUpdate(P asContext, ServerLevel level, ScheduledTick<?> entry) {
        ((PhaseContext)asContext).getTransactor().logScheduledUpdate(level, entry);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(P context) {
        ResourceLocation worldKey = ((PacketContext)context).packetPlayer.getLevel().dimension().location();
        return () -> (ResourceKey)worldKey;
    }

    public void populateContext(net.minecraft.server.level.ServerPlayer playerMP, Packet<?> packet, P context) {
    }

    public boolean isPacketIgnored(Packet<?> packetIn, net.minecraft.server.level.ServerPlayer packetPlayer) {
        return false;
    }

    protected boolean alwaysUnwinds() {
        return false;
    }

    public String toString() {
        return this.desc;
    }
}

