/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

public final class UseItemPacketState
extends BasicPacketState {
    private BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, ctx.getSpongePlayer().world());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        frame.pushCause(ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(net.minecraft.server.level.ServerPlayer playerMP, Packet<?> packet, BasicPacketContext context) {
        ServerboundUseItemPacket placeBlock = (ServerboundUseItemPacket)packet;
        ItemStack usedItem = playerMP.getItemInHand(placeBlock.getHand());
        org.spongepowered.api.item.inventory.ItemStack itemstack = ItemStackUtil.cloneDefensive(usedItem);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.getHand();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BasicPacketContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        ServerPlayer player = context.getSpongePlayer();
        BlockPos pos = VecHelper.toBlockPos(transaction.finalBlock().position());
        LevelChunkBridge spongeChunk = (LevelChunkBridge)((ServerLevel)player.world()).getChunkAt(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.bridge$addTrackedBlockPosition((Block)transaction.finalBlock().state().type(), pos, player.uniqueId(), PlayerTracker.Type.CREATOR);
        }
        spongeChunk.bridge$addTrackedBlockPosition((Block)transaction.finalBlock().state().type(), pos, player.uniqueId(), PlayerTracker.Type.NOTIFIER);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, Entity entityToSpawn) {
        org.spongepowered.api.item.inventory.ItemStack itemStack = context.getItemUsed();
        return itemStack.type() instanceof SpawnEggItem ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT;
    }

    @Override
    public void unwind(BasicPacketContext context) {
        net.minecraft.server.level.ServerPlayer player = context.getPacketPlayer();
        ItemStackSnapshot snapshot = context.getItemUsedSnapshot();
        HandType hand = context.getHandUsed();
        org.spongepowered.api.item.inventory.ItemStack itemStack = context.getItemUsed();
        boolean success = TrackingUtil.processBlockCaptures(context);
        if (!success && snapshot.isEmpty()) {
            PhaseTracker.getCauseStackManager().pushCause(player);
            PacketPhaseUtil.handlePlayerSlotRestore(player, ItemStackUtil.toNative(itemStack), (InteractionHand)hand);
        }
    }
}

