/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;

final class WorldTickState
extends TickPhaseState<WorldTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, WorldTickContext> WORLD_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        context.getSource(Object.class).ifPresent(frame::pushCause);
        @Nullable ServerLevel serverWorld = (ServerLevel)context.serverWorld.get();
        if (serverWorld != null) {
            frame.pushCause(serverWorld);
        }
    });

    WorldTickState() {
    }

    @Override
    protected WorldTickContext createNewContext(PhaseTracker tracker) {
        return new WorldTickContext(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, WorldTickContext> getFrameModifier() {
        return this.WORLD_MODIFIER;
    }

    @Override
    public void unwind(WorldTickContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(WorldTickContext context) {
        return () -> (ResourceKey)Objects.requireNonNull((ServerLevel)context.serverWorld.get(), "ServerWorld reference lost during tick").dimension().location();
    }

    public static class WorldTickContext
    extends TickContext<WorldTickContext> {
        @MonotonicNonNull WeakReference<ServerLevel> serverWorld;

        public WorldTickContext world(ServerLevel server) {
            this.serverWorld = new WeakReference<ServerLevel>(server);
            return this;
        }

        WorldTickContext(IPhaseState<WorldTickContext> phaseState, PhaseTracker tracker) {
            super(phaseState, tracker);
        }
    }
}

