/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.inventory.adapter.impl.SlotCollection;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.property.InventoryDataHolder;
import org.spongepowered.common.inventory.query.SpongeQueryTypes;

public interface DefaultImplementedAdapterInventory
extends InventoryDataHolder {
    default public Lens impl$getLens() {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getRootLens();
    }

    default public Fabric impl$getFabric() {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getFabric();
    }

    @Override
    default public Inventory root() {
        return this.parent() == this ? this : this.parent().root();
    }

    @Override
    default public Inventory parent() {
        return this;
    }

    @Override
    default public InventoryTransactionResult.Poll poll() {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens(), null);
    }

    @Override
    default public InventoryTransactionResult.Poll poll(int limit) {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens(), limit);
    }

    @Override
    default public ItemStack peek() {
        return AdapterLogic.peekSequential(this.impl$getFabric(), this.impl$getLens()).orElse(ItemStack.empty());
    }

    @Override
    default public InventoryTransactionResult offer(ItemStack ... stacks) {
        InventoryTransactionResult result = InventoryTransactionResult.successNoTransactions();
        for (ItemStack stack : stacks) {
            result = result.and(AdapterLogic.appendSequential(this.impl$getFabric(), this.impl$getLens(), stack));
        }
        return result;
    }

    @Override
    default public boolean canFit(ItemStack stack) {
        return AdapterLogic.canFit(this.impl$getFabric(), this.impl$getLens(), stack);
    }

    @Override
    default public int freeCapacity() {
        return AdapterLogic.countFreeCapacity(this.impl$getFabric(), this.impl$getLens());
    }

    @Override
    default public int totalQuantity() {
        return AdapterLogic.countQuantity(this.impl$getFabric(), this.impl$getLens());
    }

    @Override
    default public int capacity() {
        return AdapterLogic.getCapacity(this.impl$getFabric(), this.impl$getLens());
    }

    @Override
    default public boolean hasChildren() {
        return this.impl$getLens().getChildren().size() != 0;
    }

    @Override
    default public boolean contains(ItemStack stack) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack);
    }

    @Override
    default public boolean containsAny(ItemStack stack) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack, 1);
    }

    @Override
    default public boolean contains(ItemType type) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), type);
    }

    @Override
    default public List<Inventory> children() {
        return this.impl$generateChildren();
    }

    default public List<Inventory> impl$generateChildren() {
        return this.impl$getLens().getSpanningChildren().stream().map(l -> l.getAdapter(this.impl$getFabric(), this)).map(Inventory.class::cast).collect(Collectors.toList());
    }

    @Override
    default public <T extends Inventory> Optional<T> query(Class<T> inventoryType) {
        Inventory result = this.query(QueryTypes.INVENTORY_TYPE.get().of(inventoryType));
        if (inventoryType.isAssignableFrom(result.getClass())) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    @Override
    default public Inventory intersect(Inventory inventory) {
        return SpongeQueryTypes.SLOT_LENS.get().of((Set<Inventory>)ImmutableSet.of((Object)inventory)).execute(this);
    }

    @Override
    default public Inventory union(Inventory inventory) {
        return this.query(SpongeQueryTypes.UNION.get().of(inventory));
    }

    @Override
    default public boolean containsInventory(Inventory inventory) {
        Inventory result = SpongeQueryTypes.LENS.get().of(((InventoryBridge)((Object)inventory)).bridge$getAdapter().inventoryAdapter$getRootLens()).execute(this);
        return result.capacity() == inventory.capacity() && ((InventoryAdapter)((Object)result)).inventoryAdapter$getRootLens() == ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getRootLens();
    }

    @Override
    default public boolean containsChild(Inventory child) {
        return this.impl$getLens().getSpanningChildren().contains(((InventoryBridge)((Object)child)).bridge$getAdapter().inventoryAdapter$getRootLens());
    }

    @Override
    default public Optional<Slot> slot(int index) {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getSlot(index);
    }

    @Override
    default public InventoryTransactionResult.Poll pollFrom(int index) {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), null);
    }

    @Override
    default public InventoryTransactionResult.Poll pollFrom(int index, int limit) {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), limit);
    }

    @Override
    default public Optional<ItemStack> peekAt(int index) {
        return AdapterLogic.peekSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index));
    }

    @Override
    default public InventoryTransactionResult set(int index, ItemStack stack) {
        return AdapterLogic.insertSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), stack);
    }

    @Override
    default public InventoryTransactionResult offer(int index, ItemStack stack) {
        return AdapterLogic.appendSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), stack);
    }

    @Override
    default public Optional<ViewableInventory> asViewable() {
        if (this instanceof ViewableInventory) {
            return Optional.of((ViewableInventory)((Object)this));
        }
        return Optional.empty();
    }

    @Override
    default public Inventory query(Query query) {
        return query.execute(this);
    }

    @Override
    default public List<Slot> slots() {
        return SlotCollection.of(this, ((InventoryBridge)((Object)this)).bridge$getAdapter()).slots();
    }

    public static interface WithClear
    extends DefaultImplementedAdapterInventory {
        @Override
        default public void clear() {
            ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getFabric().fabric$clear();
        }
    }
}

