/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.util;

import java.util.Optional;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.carrier.chest.Chest;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.entity.player.SpongeUserData;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.custom.CarriedWrapperInventory;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static CraftingGridInventory toSpongeInventory(CraftingContainer inv) {
        return (CraftingGridInventory)inv;
    }

    public static <C extends net.minecraft.world.Container> C toNativeInventory(Inventory inv) {
        if (inv instanceof CraftingContainer) {
            return (C)((net.minecraft.world.Container)inv);
        }
        if (inv instanceof Container) {
            for (InventoryBridge inventory : ((InventoryAdapter)((Object)inv)).inventoryAdapter$getFabric().fabric$allInventories()) {
                if (!(inventory instanceof CraftingContainer)) continue;
                return (C)((net.minecraft.world.Container)inventory);
            }
        }
        throw new IllegalStateException("Invalid CraftingGridInventory. Could not find CraftingInventory.\nInventory was: " + inv.getClass().getSimpleName());
    }

    public static Optional<Inventory> getDoubleChestInventory(ChestBlockEntity chest) {
        Optional<Chest> connectedChestOptional = ((Chest)chest).connectedChest();
        if (!connectedChestOptional.isPresent()) {
            return Optional.empty();
        }
        ChestType chestType = (ChestType)chest.getBlockState().getValue((Property)ChestBlock.TYPE);
        ChestBlockEntity connectedChest = (ChestBlockEntity)connectedChestOptional.get();
        if (chestType == ChestType.RIGHT) {
            return Optional.of((Inventory)new CompoundContainer((net.minecraft.world.Container)chest, (net.minecraft.world.Container)connectedChest));
        }
        return Optional.of((Inventory)new CompoundContainer((net.minecraft.world.Container)connectedChest, (net.minecraft.world.Container)chest));
    }

    public static Inventory toInventory(net.minecraft.world.Container inventory) {
        return InventoryUtil.toInventory(inventory, null);
    }

    public static Inventory toInventory(Object inventory, @Nullable Object forgeItemHandler) {
        if (forgeItemHandler == null) {
            if (inventory instanceof ChestBlockEntity) {
                inventory = InventoryUtil.getDoubleChestInventory((ChestBlockEntity)inventory).orElse((Inventory)inventory);
            }
            if (inventory instanceof Inventory) {
                return (Inventory)inventory;
            }
        }
        if (forgeItemHandler instanceof Inventory) {
            return (Inventory)forgeItemHandler;
        }
        return PlatformHooks.INSTANCE.getInventoryHooks().toInventory(inventory, forgeItemHandler);
    }

    public static InventoryAdapter findAdapter(Object inventory) {
        if (inventory instanceof InventoryAdapter) {
            return (InventoryAdapter)inventory;
        }
        if (inventory instanceof Fabric) {
            return new BasicInventoryAdapter((Fabric)inventory, null, null);
        }
        return PlatformHooks.INSTANCE.getInventoryHooks().findInventoryAdapter(inventory);
    }

    public static TrackedInventoryBridge forCapture(Object toCapture) {
        if (toCapture instanceof TrackedInventoryBridge) {
            return (TrackedInventoryBridge)toCapture;
        }
        return null;
    }

    public static PluginContainer getPluginContainer(Object inventory) {
        PluginContainer container;
        Object base;
        Optional carrier;
        if (inventory instanceof CustomInventory) {
            return ((CustomInventory)inventory).getPlugin();
        }
        if (inventory instanceof CarriedInventory && (carrier = ((CarriedInventory)inventory).carrier()).isPresent()) {
            inventory = carrier.get();
        }
        if ((base = inventory) instanceof BlockEntity) {
            ResourceKey key = Sponge.game().registry(RegistryTypes.BLOCK_ENTITY_TYPE).valueKey(((BlockEntity)base).type());
            String pluginId = key.namespace();
            container = Sponge.pluginManager().plugin(pluginId).orElseThrow(() -> new AssertionError((Object)("Missing plugin " + pluginId + " for block " + key.namespace() + ":" + key.value())));
        } else if (base instanceof Entity) {
            ResourceKey key = (ResourceKey)EntityType.getKey((EntityType)((EntityType)((Entity)base).type()));
            String pluginId = key.namespace();
            container = Sponge.pluginManager().plugin(pluginId).orElseGet(() -> {
                SpongeCommon.logger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.instance()).minecraftPlugin();
            });
        } else {
            container = base instanceof SpongeUserData ? ((Launch)Launch.instance()).minecraftPlugin() : Sponge.pluginManager().plugin(PlatformHooks.INSTANCE.getInventoryHooks().getModIdFromInventory(base.getClass())).orElseGet(() -> {
                SpongeCommon.logger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.instance()).minecraftPlugin();
            });
        }
        return container;
    }

    public static <T extends Carrier> CarriedInventory<T> carriedWrapperInventory(net.minecraft.world.Container inventory, T carrier) {
        return (CarriedInventory)((Object)new CarriedWrapperInventory(inventory, carrier));
    }
}

